/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.registry.MidnightCriterion;
import com.mushroom.midnight.common.registry.MidnightItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class SuavisBlock
extends Block
implements IGrowable {
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)3);
    protected static final VoxelShape[] bounds = new VoxelShape[]{SuavisBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.4, (double)16.0), SuavisBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), SuavisBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), SuavisBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final ThreadLocal<PlayerEntity> HARVESTER = new ThreadLocal();

    public SuavisBlock() {
        super(Block.Properties.func_200949_a((Material)Material.field_151572_C, (MaterialColor)MaterialColor.field_151674_s).func_200951_a(12).func_200948_a(1.0f, 0.0f).func_200947_a(SoundType.field_185859_l).func_200944_c());
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)));
    }

    public BlockState getStateForPlacement(BlockState state, Direction facing, BlockState state2, IWorld world, BlockPos pos1, BlockPos pos2, Hand hand) {
        return this.func_176223_P();
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        super.func_180658_a(world, pos, entity, fallDistance);
        if (!world.field_72995_K && fallDistance > 0.8f && entity instanceof LivingEntity) {
            boolean isFirstStage;
            BlockState state = world.func_180495_p(pos);
            world.func_184133_a(null, pos, SoundEvents.field_187872_fl, SoundCategory.BLOCKS, 0.7f, 0.9f + world.field_73012_v.nextFloat() * 0.2f);
            boolean bl = isFirstStage = (Integer)state.func_177229_b((IProperty)STAGE) == 0;
            if (!isFirstStage && world.field_73012_v.nextInt(100) == 0) {
                world.func_175655_b(pos, true);
            } else {
                SuavisBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)MidnightItems.RAW_SUAVIS));
                world.func_180501_a(pos, isFirstStage ? Blocks.field_150350_a.func_176223_P() : (BlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)STAGE) - 1)), 2);
                world.func_217379_c(2001, pos, SuavisBlock.func_196246_j((BlockState)state));
                if (!(entity instanceof PlayerEntity) || !((PlayerEntity)entity).func_184812_l_()) {
                    SuavisBlock.createNauseaCloud(world, pos, 0);
                }
            }
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)MidnightItems.RAW_SUAVIS);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return false;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)STAGE) < 3;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        try {
            HARVESTER.set(player);
            super.func_180657_a(world, player, pos, state, te, stack);
        }
        finally {
            HARVESTER.remove();
        }
        if (!world.field_72995_K && !player.func_184812_l_() && player instanceof ServerPlayerEntity) {
            MidnightCriterion.HARVESTED_SUAVIS.trigger((ServerPlayerEntity)player);
        }
    }

    private static void createNauseaCloud(World world, BlockPos pos, int intensity) {
        AreaEffectCloudEntity entity = new AreaEffectCloudEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        entity.func_184483_a(1.5f + 0.5f * (float)intensity);
        entity.func_184495_b(-0.3f);
        entity.func_184485_d(10);
        entity.func_184487_c(-entity.func_184490_j() / (float)entity.func_184489_o());
        entity.func_184484_a(Potions.field_185229_a);
        entity.func_184482_a(3495830);
        entity.func_184496_a(new EffectInstance(Effects.field_76431_k, 20 * (intensity + 1) * 6, 0, false, true));
        world.func_217376_c((Entity)entity);
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)STAGE) < 3;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)STAGE) + 1)), 2);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) < 3 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            this.func_225535_a_(world, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return bounds[(Integer)state.func_177229_b((IProperty)STAGE)];
    }

    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return (Integer)state.func_177229_b((IProperty)STAGE) < 2;
    }

    public void func_220062_a(BlockState state, World world, BlockPos pos, ItemStack stack) {
        super.func_220062_a(state, world, pos, stack);
        if (world.func_201670_d()) {
            return;
        }
        PlayerEntity player = HARVESTER.get();
        if (player == null || !player.func_184812_l_() && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) == 0) {
            SuavisBlock.createNauseaCloud(world, pos, (Integer)state.func_177229_b((IProperty)STAGE));
        }
    }
}

