/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.MidnightPlantBlock;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class UnstableBushBlock
extends MidnightPlantBlock
implements IGrowable {
    public static final int MAX_STAGE = 4;
    public static final IntegerProperty STAGE = IntegerProperty.func_177719_a((String)"stage", (int)0, (int)4);
    protected static final VoxelShape[] BOUNDS = new VoxelShape[]{UnstableBushBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), UnstableBushBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), UnstableBushBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), UnstableBushBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), UnstableBushBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public UnstableBushBlock(Block.Properties properties) {
        super(properties, false);
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{STAGE});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)MidnightItems.UNSTABLE_SEEDS);
    }

    @Override
    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    @Override
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    @Override
    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) < 4) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)STAGE, (Comparable)Integer.valueOf(Math.min((Integer)state.func_177229_b((IProperty)STAGE) + 1, 4))), 2);
        } else {
            Block block = rand.nextInt(3) != 0 ? MidnightBlocks.UNSTABLE_BUSH_BLUE_BLOOMED : (rand.nextInt(3) != 0 ? MidnightBlocks.UNSTABLE_BUSH_LIME_BLOOMED : MidnightBlocks.UNSTABLE_BUSH_GREEN_BLOOMED);
            world.func_180501_a(pos, block.func_176223_P(), 2);
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (!this.func_196260_a(state, (IWorldReader)world, pos)) {
            MidnightUtil.spawnItemStack((World)world, pos, state.func_177230_c());
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        } else if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (rand.nextInt(10) == 0 ? 1 : 0) != 0)) {
            this.func_225535_a_(world, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BOUNDS[(Integer)state.func_177229_b((IProperty)STAGE)];
    }
}

