/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.block;

import com.mushroom.midnight.common.block.MidnightPlantBlock;
import com.mushroom.midnight.common.block.UnstableBushBlock;
import com.mushroom.midnight.common.item.UnstableFruitItem;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightParticleTypes;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class UnstableBushBloomedBlock
extends MidnightPlantBlock
implements IGrowable {
    public static final BooleanProperty HAS_FRUIT = BooleanProperty.func_177716_a((String)"has_fruit");
    private final Supplier<Item> fruitSupplier;

    public UnstableBushBloomedBlock(Block.Properties properties, Supplier<Item> fruitSupplier) {
        super(properties, true);
        this.fruitSupplier = fruitSupplier;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (((Boolean)state.func_177229_b((IProperty)HAS_FRUIT)).booleanValue()) {
            if (!world.field_72995_K) {
                int fruitCount = world.field_73012_v.nextInt(3) + 1;
                for (int i = 0; i < fruitCount; ++i) {
                    MidnightUtil.spawnItemStack(world, pos, this.fruitSupplier.get()).func_213315_a(MoverType.SELF, new Vec3d((double)(world.field_73012_v.nextFloat() * 0.12f - 0.06f), (double)-0.06f, (double)(world.field_73012_v.nextFloat() * 0.12f - 0.06f)));
                }
                world.func_180501_a(pos, (BlockState)MidnightBlocks.UNSTABLE_BUSH.func_176223_P().func_206870_a((IProperty)UnstableBushBlock.STAGE, (Comparable)Integer.valueOf(4)), 2);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{HAS_FRUIT});
    }

    @Override
    public boolean func_176473_a(IBlockReader world, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FRUIT) == false;
    }

    @Override
    public boolean func_180670_a(World world, Random rand, BlockPos pos, BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FRUIT) == false;
    }

    @Override
    public void func_225535_a_(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        world.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)HAS_FRUIT, (Comparable)Boolean.valueOf(true)), 2);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (BlockState)state, (rand.nextInt(10) == 0 ? 1 : 0) != 0)) {
            this.func_225535_a_(world, rand, pos, state);
            ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)this.fruitSupplier.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        int fruitType;
        int n = fruitType = this.fruitSupplier.get() instanceof UnstableFruitItem ? ((UnstableFruitItem)this.fruitSupplier.get()).color.ordinal() : 0;
        if (rand.nextInt(10) == 0) {
            world.func_195594_a((IParticleData)(fruitType == 0 ? MidnightParticleTypes.BLUE_UNSTABLE_BUSH : (fruitType == 1 ? MidnightParticleTypes.LIME_UNSTABLE_BUSH : MidnightParticleTypes.GREEN_UNSTABLE_BUSH)), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (double)rand.nextFloat() * 0.1 - 0.05, (double)rand.nextFloat() * 0.03, (double)rand.nextFloat() * 0.1 - 0.05);
        }
    }
}

