/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.ifc;

import com.mushroom.midnight.client.gui.config.ConfigInterfaceScreen;
import com.mushroom.midnight.client.gui.config.ConfigOptionList;
import com.mushroom.midnight.common.config.ifc.EditAccess;
import com.mushroom.midnight.common.config.ifc.IConfigControlType;
import com.mushroom.midnight.common.config.provider.IConfigProvider;
import com.mushroom.midnight.common.config.provider.IConfigValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConfigInterface {
    private final ITextComponent title;
    private final IConfigProvider provider;
    private final boolean canCancel;
    private final List<Entry> entries = new ArrayList<Entry>();
    private final List<IConfigValue<?>> values = new ArrayList();
    private final EditAccess access;
    private Runnable changeHandler;

    public ConfigInterface(ITextComponent title, IConfigProvider provider, boolean canCancel, EditAccess access) {
        this.title = title;
        this.provider = provider;
        this.canCancel = canCancel;
        this.access = access;
    }

    public ConfigInterface handler(Runnable changeHandler) {
        this.changeHandler = changeHandler;
        return this;
    }

    public ConfigInterface header(String headerTK) {
        this.entries.add(new HeaderEntry(headerTK));
        return this;
    }

    public ConfigInterface category(String categoryTK, ConfigInterface cfgInterface) {
        this.entries.add(new CategoryEntry(categoryTK, categoryTK + ".tooltip", cfgInterface));
        return this;
    }

    public ConfigInterface category(String categoryTK, String descTK, ConfigInterface cfgInterface) {
        this.entries.add(new CategoryEntry(categoryTK, descTK, cfgInterface));
        return this;
    }

    public <T> ConfigInterface setting(String settingTK, IConfigControlType<T> type, String path) {
        IConfigValue config = this.provider.configValue(path);
        this.entries.add(new ConfigEntry(settingTK, settingTK + ".tooltip", type, config));
        this.values.add(config);
        return this;
    }

    public <T> ConfigInterface setting(String settingTK, String descTK, IConfigControlType<T> type, String path) {
        IConfigValue config = this.provider.configValue(path);
        this.entries.add(new ConfigEntry(settingTK, descTK, type, config));
        this.values.add(config);
        return this;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public boolean canCancel() {
        return this.canCancel;
    }

    public EditAccess getAccess() {
        return this.access;
    }

    public void saveAll() {
        for (IConfigValue<?> value : this.values) {
            value.save();
        }
    }

    public void discardAll() {
        for (IConfigValue<?> value : this.values) {
            value.discard();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillOptionsScreen(ConfigInterfaceScreen screen, ConfigOptionList scrollView) {
        for (Entry entry : this.entries) {
            scrollView.addEntry(entry.createRow(screen));
        }
    }

    public void handleChange() {
        if (this.changeHandler != null) {
            this.changeHandler.run();
        }
    }

    public Snapshot createSnapshot() {
        return new Snapshot(this.values);
    }

    @FunctionalInterface
    public static interface Factory {
        public ConfigInterface makeInterface(IConfigProvider var1);
    }

    public static class Snapshot {
        private final Map<IConfigValue<?>, Object> snapshotValues = new HashMap();

        private Snapshot(List<IConfigValue<?>> values) {
            for (IConfigValue<?> value : values) {
                this.snapshotValues.put(value, value.get());
            }
        }

        public void revert() {
            for (Map.Entry<IConfigValue<?>, Object> entry : this.snapshotValues.entrySet()) {
                entry.getKey().set(entry.getValue());
            }
        }
    }

    private static class ConfigEntry<T>
    implements Entry {
        private final String nameTK;
        private final String tooltipTK;
        private final IConfigControlType<T> type;
        private final IConfigValue<T> cfg;

        private ConfigEntry(String nameTK, String tooltipTK, IConfigControlType<T> type, IConfigValue<T> cfg) {
            this.nameTK = nameTK;
            this.tooltipTK = tooltipTK;
            this.type = type;
            this.cfg = cfg;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigOptionList.Row createRow(ConfigInterfaceScreen screen) {
            ConfigOptionList.Row row = new ConfigOptionList.Row(I18n.func_135052_a((String)this.nameTK, (Object[])new Object[0]), this.type.createConfigWidget(this.cfg).asWidget(), screen);
            if (I18n.func_188566_a((String)this.tooltipTK)) {
                row.withTooltip(I18n.func_135052_a((String)this.tooltipTK, (Object[])new Object[0]));
            }
            return row;
        }
    }

    private static class CategoryEntry
    implements Entry {
        private final String buttonTK;
        private final String tooltipTK;
        private final ConfigInterface cfgInterface;

        private CategoryEntry(String buttonTK, String tooltipTK, ConfigInterface cfgInterface) {
            this.buttonTK = buttonTK;
            this.tooltipTK = tooltipTK;
            this.cfgInterface = cfgInterface;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigOptionList.Row createRow(ConfigInterfaceScreen screen) {
            Button button = new Button(0, 0, 200, 20, I18n.func_135052_a((String)this.buttonTK, (Object[])new Object[0]), btn -> screen.openCategory(this.cfgInterface));
            button.active = this.cfgInterface.getAccess().canEdit(Minecraft.func_71410_x());
            ConfigOptionList.ButtonOnlyRow row = new ConfigOptionList.ButtonOnlyRow((Widget)button, screen);
            if (I18n.func_188566_a((String)this.tooltipTK)) {
                row.withTooltip(I18n.func_135052_a((String)this.tooltipTK, (Object[])new Object[0]));
            }
            return row;
        }
    }

    private static class HeaderEntry
    implements Entry {
        private final String headerTK;

        private HeaderEntry(String headerTK) {
            this.headerTK = headerTK;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public ConfigOptionList.Row createRow(ConfigInterfaceScreen screen) {
            return new ConfigOptionList.HeaderRow(I18n.func_135052_a((String)this.headerTK, (Object[])new Object[0]), screen);
        }
    }

    @FunctionalInterface
    private static interface Entry {
        @OnlyIn(value=Dist.CLIENT)
        public ConfigOptionList.Row createRow(ConfigInterfaceScreen var1);
    }
}

