/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.ifc;

import com.mushroom.midnight.client.gui.config.widget.IConfigWidget;
import com.mushroom.midnight.common.config.ifc.IConfigControlType;
import com.mushroom.midnight.common.config.provider.IConfigValue;
import java.util.function.Function;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DoublePercentSliderControl
implements IConfigControlType<Double> {
    private final Function<Integer, String> format;

    public DoublePercentSliderControl(String format, String minName, String maxName) {
        this.format = i -> i == 0 ? minName : (i == 100 ? maxName : format);
    }

    public DoublePercentSliderControl(String format) {
        this.format = i -> format;
    }

    public DoublePercentSliderControl() {
        this("config.midnight.format.number_basic");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IConfigWidget<Double> createConfigWidget(IConfigValue<Double> configValue) {
        return new CfgWidget(configValue, this.format);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class CfgWidget
    implements IConfigWidget<Double> {
        private final IConfigValue<Double> configValue;
        private final Slider slider;
        private final Function<Integer, String> format;

        private CfgWidget(IConfigValue<Double> configValue, Function<Integer, String> format) {
            this.configValue = configValue;
            this.format = format;
            this.slider = new Slider(0, 0, 150, 20, configValue.get());
            this.slider.updateMessage();
        }

        private int toRange(double pct) {
            return (int)(pct * 100.0);
        }

        @Override
        public IConfigValue<Double> getConfigValue() {
            return this.configValue;
        }

        @Override
        public Widget asWidget() {
            return this.slider;
        }

        @OnlyIn(value=Dist.CLIENT)
        private class Slider
        extends AbstractSlider {
            protected Slider(int x, int y, int width, int height, double value) {
                super(x, y, width, height, value);
            }

            protected void updateMessage() {
                int val = CfgWidget.this.toRange(this.value);
                this.setMessage(I18n.func_135052_a((String)((String)CfgWidget.this.format.apply(val)), (Object[])new Object[]{val}));
            }

            protected void applyValue() {
                CfgWidget.this.configValue.set(this.value);
            }
        }
    }
}

