/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.ifc;

import com.mushroom.midnight.client.gui.config.widget.IConfigWidget;
import com.mushroom.midnight.common.config.ifc.IConfigControlType;
import com.mushroom.midnight.common.config.provider.IConfigValue;
import java.util.function.Function;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IntSliderControl
implements IConfigControlType<Integer> {
    private final int min;
    private final int max;
    private final Function<Integer, String> format;

    public IntSliderControl(int min, int max, String format, String minName, String maxName) {
        this.min = min;
        this.max = max;
        this.format = i -> i == min ? minName : (i == max ? maxName : format);
    }

    public IntSliderControl(int min, int max, String format) {
        this.min = min;
        this.max = max;
        this.format = i -> format;
    }

    public IntSliderControl(int min, int max) {
        this(min, max, "config.midnight.format.number_basic");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IConfigWidget<Integer> createConfigWidget(IConfigValue<Integer> configValue) {
        return new CfgWidget(configValue, this.format, this.min, this.max);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class CfgWidget
    implements IConfigWidget<Integer> {
        private final IConfigValue<Integer> configValue;
        private final Slider slider;
        private final Function<Integer, String> format;
        private final int min;
        private final int max;

        private CfgWidget(IConfigValue<Integer> configValue, Function<Integer, String> format, int min, int max) {
            this.configValue = configValue;
            this.format = format;
            this.min = min;
            this.max = max;
            this.slider = new Slider(0, 0, 150, 20, this.fromRange(configValue.get()));
            this.slider.updateMessage();
        }

        private int toRange(double pct) {
            return (int)(pct * (double)(this.max - this.min) + (double)this.min);
        }

        private double fromRange(int val) {
            return (double)(val - this.min) / (double)(this.max - this.min);
        }

        @Override
        public IConfigValue<Integer> getConfigValue() {
            return this.configValue;
        }

        @Override
        public Widget asWidget() {
            return this.slider;
        }

        @OnlyIn(value=Dist.CLIENT)
        private class Slider
        extends AbstractSlider {
            protected Slider(int x, int y, int width, int height, double value) {
                super(x, y, width, height, value);
            }

            protected void updateMessage() {
                int val = CfgWidget.this.toRange(this.value);
                this.setMessage(I18n.func_135052_a((String)((String)CfgWidget.this.format.apply(val)), (Object[])new Object[]{val}));
            }

            protected void applyValue() {
                CfgWidget.this.configValue.set(CfgWidget.this.toRange(this.value));
            }
        }
    }
}

