/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.config.provider;

import com.mushroom.midnight.common.config.provider.IConfigValue;
import net.minecraftforge.common.ForgeConfigSpec;

public class ForgeConfigValue<T>
implements IConfigValue<T> {
    private final ForgeConfigSpec.ConfigValue<T> configValue;
    private T value;
    private boolean initalized;

    public ForgeConfigValue(ForgeConfigSpec.ConfigValue<T> configValue) {
        this.configValue = configValue;
    }

    private void init() {
        if (this.initalized) {
            return;
        }
        this.value = this.configValue.get();
        this.initalized = true;
    }

    @Override
    public void set(T value) {
        this.init();
        this.value = value;
    }

    @Override
    public T get() {
        this.init();
        return this.value;
    }

    @Override
    public void save() {
        if (!this.initalized) {
            return;
        }
        if (this.value != this.configValue.get()) {
            this.configValue.set(this.value);
            this.configValue.save();
        }
    }

    @Override
    public void discard() {
        if (!this.initalized) {
            return;
        }
        this.value = this.configValue.get();
    }
}

