/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.data.recipe;

import com.mushroom.midnight.common.data.Triggers;
import com.mushroom.midnight.common.data.recipe.MidnightCookingRecipeBuilder;
import com.mushroom.midnight.common.registry.MidnightRecipeSerializers;
import com.mushroom.midnight.common.registry.MidnightTags;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.SingleItemRecipeBuilder;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class StandardRecipes {
    private final Consumer<IFinishedRecipe> consumer;

    StandardRecipes(Consumer<IFinishedRecipe> consumer) {
        this.consumer = consumer;
    }

    public static StandardRecipes into(Consumer<IFinishedRecipe> consumer) {
        return new StandardRecipes(consumer);
    }

    public Material ofMaterial(IItemProvider material) {
        return new Material(this.consumer, material);
    }

    public StandardRecipes addPlanks(IItemProvider material, IItemProvider planks) {
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)planks, (int)4).func_200487_b(material).func_200483_a("has_log", (ICriterionInstance)Triggers.hasItem(material)).func_200482_a(this.consumer);
        return this;
    }

    public StandardRecipes addFood(IItemProvider raw, IItemProvider cooked) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)cooked.func_199767_j());
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{raw}), (IItemProvider)cooked, (float)0.35f, (int)200).func_218628_a("has_raw", (ICriterionInstance)Triggers.hasItem(raw)).func_218630_a(this.consumer);
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{raw}), (IItemProvider)cooked, (float)0.35f, (int)100, (CookingRecipeSerializer)IRecipeSerializer.field_222173_q).func_218628_a("has_raw", (ICriterionInstance)Triggers.hasItem(raw)).func_218635_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_from_smoking"));
        CookingRecipeBuilder.func_218631_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{raw}), (IItemProvider)cooked, (float)0.35f, (int)400, (CookingRecipeSerializer)IRecipeSerializer.field_222174_r).func_218628_a("has_raw", (ICriterionInstance)Triggers.hasItem(raw)).func_218635_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_from_campfire_cooking"));
        return this;
    }

    public StandardRecipes addMidnightFoodSmelting(IItemProvider raw, IItemProvider cooked) {
        MidnightCookingRecipeBuilder.cookingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{raw}), cooked, 0.35f, 200, MidnightRecipeSerializers.SMELTING).addCriterion("has_raw", (ICriterionInstance)Triggers.hasItem(raw)).build(this.consumer);
        return this;
    }

    public StandardRecipes addMidnightIngotSmelting(IItemProvider raw, IItemProvider cooked) {
        MidnightCookingRecipeBuilder.cookingRecipe(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{raw}), cooked, 1.0f, 200, MidnightRecipeSerializers.SMELTING).addCriterion("has_ore", (ICriterionInstance)Triggers.hasItem(raw)).build(this.consumer);
        return this;
    }

    public StandardRecipes addIngot(IItemProvider ore, IItemProvider ingot) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)ingot.func_199767_j());
        CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)ingot, (float)1.0f, (int)200).func_218628_a("has_ore", (ICriterionInstance)Triggers.hasItem(ore)).func_218630_a(this.consumer);
        CookingRecipeBuilder.func_218633_b((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ore}), (IItemProvider)ingot, (float)1.0f, (int)100).func_218628_a("has_ore", (ICriterionInstance)Triggers.hasItem(ore)).func_218635_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_from_blasting"));
        return this;
    }

    public static class Material {
        private final Consumer<IFinishedRecipe> consumer;
        private final IItemProvider material;

        private Material(Consumer<IFinishedRecipe> consumer, IItemProvider material) {
            this.consumer = consumer;
            this.material = material;
        }

        public Material addButton(IItemProvider button) {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)button).func_200487_b(this.material).func_200490_a("midnight_buttons").func_200483_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200482_a(this.consumer);
            return this;
        }

        public Material addChest(IItemProvider chest) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)chest).func_200472_a("###").func_200472_a("# #").func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addCraftingTable(IItemProvider craftingTable) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)craftingTable).func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addDoor(IItemProvider door) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)door, (int)3).func_200472_a("##").func_200472_a("##").func_200472_a("##").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200473_b("midnight_doors").func_200464_a(this.consumer);
            return this;
        }

        public Material addFence(IItemProvider fence) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)fence, (int)3).func_200472_a("#|#").func_200472_a("#|#").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200473_b("midnight_fences").func_200464_a(this.consumer);
            return this;
        }

        public Material addFenceGate(IItemProvider fenceGate) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)fenceGate).func_200472_a("|#|").func_200472_a("|#|").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200473_b("midnight_fence_gates").func_200464_a(this.consumer);
            return this;
        }

        public Material addLadder(IItemProvider ladder) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)ladder, (int)3).func_200472_a("| |").func_200472_a("|#|").func_200472_a("| |").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addPressurePlate(IItemProvider pressurePlate) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)pressurePlate).func_200472_a("##").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addSlab(IItemProvider slab) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)slab, (int)6).func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addStoneSlab(IItemProvider slab) {
            this.addSlab(slab);
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)slab.func_199767_j());
            SingleItemRecipeBuilder.func_218644_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.material}), (IItemProvider)slab, (int)2).func_218643_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_218647_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_stonecutting"));
            return this;
        }

        public Material addStairs(IItemProvider stairs) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)stairs, (int)4).func_200472_a("#  ").func_200472_a("## ").func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addStoneStairs(IItemProvider stairs) {
            this.addStairs(stairs);
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)stairs.func_199767_j());
            SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.material}), (IItemProvider)stairs).func_218643_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_218647_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_stonecutting"));
            return this;
        }

        public Material addTrapDoor(IItemProvider trapDoor) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)trapDoor, (int)6).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addWall(IItemProvider wall) {
            ShapedRecipeBuilder.func_200468_a((IItemProvider)wall, (int)6).func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)wall.func_199767_j());
            SingleItemRecipeBuilder.func_218648_a((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.material}), (IItemProvider)wall).func_218643_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_218647_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_stonecutting"));
            return this;
        }

        public Material addPickaxe(IItemProvider pickaxe) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)pickaxe).func_200472_a("###").func_200472_a(" | ").func_200472_a(" | ").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addAxe(IItemProvider axe) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)axe).func_200472_a("##").func_200472_a("|#").func_200472_a("| ").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addSword(IItemProvider sword) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)sword).func_200472_a("#").func_200472_a("#").func_200472_a("|").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addShovel(IItemProvider shovel) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)shovel).func_200472_a("#").func_200472_a("|").func_200472_a("|").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addHoe(IItemProvider hoe) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)hoe).func_200472_a("##").func_200472_a("| ").func_200472_a("| ").func_200462_a(Character.valueOf('#'), this.material).func_200469_a(Character.valueOf('|'), MidnightTags.Items.STICKS).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addHelmet(IItemProvider helmet) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)helmet).func_200472_a("###").func_200472_a("# #").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addChestPlate(IItemProvider chestPlate) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)chestPlate).func_200472_a("# #").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addLeggings(IItemProvider leggings) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)leggings).func_200472_a("###").func_200472_a("# #").func_200472_a("# #").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addBoots(IItemProvider boots) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)boots).func_200472_a("# #").func_200472_a("# #").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addShears(IItemProvider shears) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)shears).func_200472_a(" #").func_200472_a("# ").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addBuckets(IItemProvider buckets) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)buckets).func_200472_a("# #").func_200472_a(" # ").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            return this;
        }

        public Material addStorageBlock(IItemProvider block) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)block).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), this.material).func_200465_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200464_a(this.consumer);
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.material.func_199767_j());
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)this.material, (int)9).func_200487_b(block).func_200483_a("has_item", (ICriterionInstance)Triggers.hasItem(block)).func_200485_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_from_block"));
            return this;
        }

        public Material addNugget(IItemProvider nugget) {
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)nugget.func_199767_j());
            ShapedRecipeBuilder.func_200470_a((IItemProvider)this.material).func_200472_a("###").func_200472_a("###").func_200472_a("###").func_200462_a(Character.valueOf('#'), nugget).func_200465_a("has_nugget", (ICriterionInstance)Triggers.hasItem(nugget)).func_200467_a(this.consumer, MidnightUtil.transformPath(id, path -> path + "_from_nuggets"));
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)nugget, (int)9).func_200487_b(this.material).func_200483_a("has_item", (ICriterionInstance)Triggers.hasItem(this.material)).func_200482_a(this.consumer);
            return this;
        }
    }
}

