/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.registry.MidnightEntities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.arguments.ParticleArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CloudEntity
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(CloudEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(CloudEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.func_187226_a(CloudEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<IParticleData> PARTICLE = EntityDataManager.func_187226_a(CloudEntity.class, (IDataSerializer)DataSerializers.field_198166_i);
    private Potion potion = Potions.field_185229_a;
    private final List<EffectInstance> effects = new ArrayList<EffectInstance>();
    private final Map<Entity, Integer> reapplicationDelayMap = new HashMap<Entity, Integer>();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUniqueId;
    private boolean allowTeleport = false;

    public CloudEntity(World world) {
        super(MidnightEntities.CLOUD, world);
    }

    public CloudEntity(EntityType<CloudEntity> entityType, World world) {
        super(entityType, world);
        this.field_70145_X = true;
        this.setRadius(3.0f);
    }

    public CloudEntity(World world, double x, double y, double z) {
        this(MidnightEntities.CLOUD, world);
        this.func_70107_b(x, y, z);
    }

    public CloudEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(MidnightEntities.CLOUD, world);
    }

    public CloudEntity setAllowTeleport() {
        this.allowTeleport = true;
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)0);
        this.field_70180_af.func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(IGNORE_RADIUS, (Object)false);
        this.field_70180_af.func_187214_a(PARTICLE, (Object)ParticleTypes.field_197625_r);
    }

    public void func_213323_x_() {
        double x = this.func_226277_ct_();
        double y = this.func_226278_cu_();
        double z = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(x, y, z);
    }

    public CloudEntity setRadius(float radius) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        }
        return this;
    }

    public float getRadius() {
        return ((Float)this.field_70180_af.func_187225_a(RADIUS)).floatValue();
    }

    public CloudEntity setPotion(Potion potion) {
        this.potion = potion;
        if (!this.colorSet) {
            this.updateFixedColor();
        }
        return this;
    }

    private void updateFixedColor() {
        if (this.potion == Potions.field_185229_a && this.effects.isEmpty()) {
            this.field_70180_af.func_187227_b(COLOR, (Object)0);
        } else {
            this.field_70180_af.func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.effects)));
        }
    }

    public CloudEntity addEffect(EffectInstance effect) {
        this.effects.add(effect);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
        return this;
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public CloudEntity setColor(int color) {
        this.colorSet = true;
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
        return this;
    }

    public IParticleData getParticleData() {
        return (IParticleData)this.field_70180_af.func_187225_a(PARTICLE);
    }

    public CloudEntity setParticleData(IParticleData particle) {
        this.field_70180_af.func_187227_b(PARTICLE, (Object)particle);
        return this;
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.field_70180_af.func_187227_b(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public CloudEntity setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public void func_70071_h_() {
        List list;
        super.func_70071_h_();
        boolean flag = this.shouldIgnoreRadius();
        float f = this.getRadius();
        if (this.field_70170_p.field_72995_K) {
            IParticleData particle = this.getParticleData();
            if (flag) {
                if (this.field_70146_Z.nextBoolean()) {
                    for (int i = 0; i < 2; ++i) {
                        float f1 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float f2 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                        float f3 = MathHelper.func_76134_b((float)f1) * f2;
                        float f4 = MathHelper.func_76126_a((float)f1) * f2;
                        this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + (double)f3, this.func_226278_cu_(), this.func_226281_cx_() + (double)f4, 0.0, 0.0, 0.0);
                    }
                }
            } else {
                float f5 = (float)Math.PI * f * f;
                int k1 = 0;
                while ((float)k1 < f5) {
                    float f6 = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float f7 = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * f;
                    float f8 = MathHelper.func_76134_b((float)f6) * f7;
                    float f9 = MathHelper.func_76126_a((float)f6) * f7;
                    this.field_70170_p.func_195594_a(particle, this.func_226277_ct_() + (double)f8, this.func_226278_cu_(), this.func_226281_cx_() + (double)f9, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15);
                    ++k1;
                }
            }
        } else {
            boolean flag1;
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            boolean bl = flag1 = this.field_70173_aa < this.waitTime;
            if (flag != flag1) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((f += this.radiusPerTick) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(f);
            }
            if (this.field_70173_aa % 5 == 0) {
                this.reapplicationDelayMap.entrySet().removeIf(entry -> this.field_70173_aa >= (Integer)entry.getValue());
                ArrayList<EffectInstance> potions = new ArrayList<EffectInstance>();
                for (EffectInstance effect : this.potion.func_185170_a()) {
                    potions.add(new EffectInstance(effect.func_188419_a(), effect.func_76459_b() / 4, effect.func_76458_c(), effect.func_82720_e(), effect.func_188418_e()));
                }
                potions.addAll(this.effects);
                if (potions.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List list2 = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
                    if (!list2.isEmpty()) {
                        for (LivingEntity entity : list2) {
                            double d1;
                            double d0;
                            double d2;
                            if (this.reapplicationDelayMap.containsKey(entity) || !entity.func_184603_cC() || !((d2 = (d0 = entity.func_226277_ct_() - this.func_226277_ct_()) * d0 + (d1 = entity.func_226281_cx_() - this.func_226281_cx_()) * d1) <= (double)(f * f))) continue;
                            this.reapplicationDelayMap.put((Entity)entity, this.field_70173_aa + this.reapplicationDelay);
                            for (EffectInstance effect : potions) {
                                if (effect.func_188419_a().func_76403_b()) {
                                    effect.func_188419_a().func_180793_a((Entity)this, (Entity)this.getOwner(), entity, effect.func_76458_c(), 0.5);
                                    continue;
                                }
                                entity.func_195064_c(new EffectInstance(effect));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((f += this.radiusOnUse) < 0.5f) {
                                    this.func_70106_y();
                                    return;
                                }
                                this.setRadius(f);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.func_70106_y();
                            return;
                        }
                    }
                }
            }
        }
        if (this.allowTeleport && !this.field_70170_p.field_72995_K && this.func_70089_S() && this.field_70170_p.func_82737_E() % 40L == 0L && !(list = this.field_70170_p.func_175674_a((Entity)this.getOwner(), this.func_174813_aQ().func_186662_g(5.0), p -> p instanceof LivingEntity && p.func_70089_S())).isEmpty()) {
            Entity entity = (Entity)list.get(this.field_70170_p.field_73012_v.nextInt(list.size()));
            this.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        }
    }

    public CloudEntity setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
        return this;
    }

    public CloudEntity setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
        return this;
    }

    public CloudEntity setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
        return this;
    }

    public CloudEntity setOwner(@Nullable LivingEntity owner) {
        this.owner = owner;
        this.ownerUniqueId = owner == null ? null : owner.func_110124_au();
        return this;
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.durationOnUse = compound.func_74762_e("DurationOnUse");
        this.radiusOnUse = compound.func_74760_g("RadiusOnUse");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        this.ownerUniqueId = compound.func_186857_a("OwnerUUID");
        if (compound.func_150297_b("Particle", 8)) {
            try {
                this.setParticleData(ParticleArgument.func_197189_a((StringReader)new StringReader(compound.func_74779_i("Particle"))));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                Midnight.LOGGER.warn("Couldn't load custom particle {}", (Object)compound.func_74779_i("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_150297_b("Potion", 8)) {
            this.setPotion(PotionUtils.func_185187_c((CompoundNBT)compound));
        }
        if (compound.func_150297_b("Effects", 9)) {
            ListNBT list = compound.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < list.size(); ++i) {
                EffectInstance effectInstance = EffectInstance.func_82722_b((CompoundNBT)list.func_150305_b(i));
                if (effectInstance == null) continue;
                this.addEffect(effectInstance);
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74768_a("DurationOnUse", this.durationOnUse);
        compound.func_74776_a("RadiusOnUse", this.radiusOnUse);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        compound.func_74778_a("Particle", this.getParticleData().func_197555_a());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUniqueId);
        }
        if (this.colorSet) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (this.potion != Potions.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListNBT list = new ListNBT();
            for (EffectInstance effect : this.effects) {
                list.add((Object)effect.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("Effects", (INBT)list);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.setRadius(this.getRadius());
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

