/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightSounds;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AmbientEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CrystalBugEntity
extends AmbientEntity {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(CrystalBugEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private BlockPos spawnPosition;

    public CrystalBugEntity(EntityType<? extends CrystalBugEntity> entityType, World world) {
        super(entityType, world);
        this.field_70728_aV = 3;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return this.func_180425_c().func_177956_o() > this.field_70170_p.func_181545_F();
    }

    public int func_70641_bl() {
        return 10;
    }

    protected float func_70599_aP() {
        return 0.2f;
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    private void setStanding(boolean isStanding) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)isStanding);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isStanding()) {
            this.func_213317_d(Vec3d.field_186680_a);
        } else {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.4, 1.0));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)compound.func_74767_n("isStanding"));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("isStanding", ((Boolean)this.field_70180_af.func_187225_a(IS_STANDING)).booleanValue());
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.isStanding()) {
            this.setStanding(false);
        }
        return super.func_70097_a(source, amount);
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        BlockPos blockpos = new BlockPos((Entity)this);
        BlockPos blockpos1 = blockpos.func_177972_a(this.func_174811_aO());
        if (this.isStanding()) {
            if (this.canStayOnBlock(this.field_70170_p.func_180495_p(blockpos1))) {
                if (this.field_70170_p.func_217362_a((Entity)this, 4.0) != null) {
                    this.setStanding(false);
                    this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
                }
            } else {
                this.setStanding(false);
                this.field_70170_p.func_217378_a(null, 1025, blockpos, 0);
            }
        } else {
            if (!(this.spawnPosition == null || this.field_70170_p.func_175623_d(this.spawnPosition) && this.spawnPosition.func_177956_o() >= 1)) {
                this.spawnPosition = null;
            }
            if (this.spawnPosition == null || this.field_70146_Z.nextInt(30) == 0 || this.spawnPosition.func_218140_a((double)((int)this.func_226277_ct_()), (double)((int)this.func_226278_cu_()), (double)((int)this.func_226281_cx_()), true) < 4.0) {
                this.spawnPosition = new BlockPos((int)this.func_226277_ct_() + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7), (int)this.func_226278_cu_() + this.field_70146_Z.nextInt(6) - 2, (int)this.func_226281_cx_() + this.field_70146_Z.nextInt(7) - this.field_70146_Z.nextInt(7));
            }
            double d0 = (double)this.spawnPosition.func_177958_n() + 0.5 - this.func_226277_ct_();
            double d1 = (double)this.spawnPosition.func_177956_o() + 0.1 - this.func_226278_cu_();
            double d2 = (double)this.spawnPosition.func_177952_p() + 0.5 - this.func_226281_cx_();
            double addX = (Math.signum(d0) * 0.2 - this.func_213322_ci().field_72450_a) * 0.1;
            double addY = (Math.signum(d1) * 0.4 - this.func_213322_ci().field_72448_b) * 0.1;
            double addZ = (Math.signum(d2) * 0.2 - this.func_213322_ci().field_72449_c) * 0.1;
            this.func_213317_d(this.func_213322_ci().func_72441_c(addX, addY, addZ));
            float f = (float)(MathHelper.func_181159_b((double)this.func_213322_ci().field_72449_c, (double)this.func_213322_ci().field_72450_a) * 57.29577951308232) - 90.0f;
            float f1 = MathHelper.func_76142_g((float)(f - this.field_70177_z));
            this.field_191988_bg = 0.2f;
            this.field_70177_z += f1;
            if (this.field_70146_Z.nextInt(100) == 0 && this.canStayOnBlock(this.field_70170_p.func_180495_p(blockpos1))) {
                this.setStanding(true);
                this.spawnPosition = blockpos1;
            }
        }
        if (!this.isStanding() && this.field_70173_aa % 80 == 0) {
            this.field_70170_p.func_184133_a(null, this.func_180425_c(), MidnightSounds.CRYSTAL_BUG_FLYING, SoundCategory.NEUTRAL, this.func_70681_au().nextFloat() * 0.6f, this.func_70681_au().nextFloat() * 0.15f);
        }
    }

    private boolean canStayOnBlock(BlockState state) {
        return state.func_177230_c() == MidnightBlocks.BLOOMCRYSTAL_ROCK;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b / 3.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MidnightSounds.CRYSTAL_BUG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MidnightSounds.CRYSTAL_BUG_DEATH;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }
}

