/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.block.UnstableBushBlock;
import com.mushroom.midnight.common.block.UnstableBushBloomedBlock;
import com.mushroom.midnight.common.capability.AnimationCapability;
import com.mushroom.midnight.common.entity.task.ChargeGoal;
import com.mushroom.midnight.common.entity.task.EatGrassGoal;
import com.mushroom.midnight.common.entity.task.NeutralGoal;
import com.mushroom.midnight.common.entity.task.SearchForBlockGoal;
import com.mushroom.midnight.common.item.UnstableFruitItem;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightCriterion;
import com.mushroom.midnight.common.registry.MidnightEffects;
import com.mushroom.midnight.common.registry.MidnightEntities;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.registry.MidnightSurfaceBiomes;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.IProperty;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class NightStagEntity
extends AnimalEntity {
    private static final DataParameter<Integer> ANTLER_TYPE = EntityDataManager.func_187226_a(NightStagEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final int MAX_ANTLER_TYPE = 9;
    private static final AttributeModifier CHILD_ATTACK_MALUS = new AttributeModifier(UUID.fromString("c0f32cda-a4fd-4fe4-8b3f-15612ef9a52f"), "nightstag_child_attack_malus", -2.0, AttributeModifier.Operation.ADDITION);
    private static final int GROWING_TIME = -24000;
    private static final Predicate<BlockState> FRUIT_PREDICATE = p -> p.func_177230_c() instanceof UnstableBushBloomedBlock && (Boolean)p.func_177229_b((IProperty)UnstableBushBloomedBlock.HAS_FRUIT) != false;
    private final AnimationCapability animCap = new AnimationCapability();
    private int temptTime = 400;

    public NightStagEntity(EntityType<? extends NightStagEntity> entityType, World world) {
        super(entityType, world);
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity entity) {
        NightStagEntity child = (NightStagEntity)MidnightEntities.NIGHTSTAG.func_200721_a(this.field_70170_p);
        if (child != null) {
            child.func_70873_a(-24000);
            child.setAntlerType(((NightStagEntity)entity).getAntlerType());
        }
        return child;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData livingdata, @Nullable CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        if (MidnightUtil.isMidnightDimension(this.field_70170_p)) {
            Biome biome = this.field_70170_p.func_226691_t_(this.func_180425_c());
            int random = this.field_70146_Z.nextInt(3);
            if (biome == MidnightSurfaceBiomes.VIGILANT_FOREST || biome == MidnightSurfaceBiomes.HILLY_VIGILANT_FOREST) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 3 : 7));
            } else if (biome == MidnightSurfaceBiomes.NIGHT_PLAINS || biome == MidnightSurfaceBiomes.WARPED_FIELDS) {
                this.setAntlerType(random == 0 ? 0 : 1);
            } else if (biome == MidnightSurfaceBiomes.RUNEBUSH_GROVE) {
                this.setAntlerType(random == 0 ? 3 : 8);
            } else if (biome == MidnightSurfaceBiomes.DECEITFUL_BOG) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 2 : 4));
            } else if (biome == MidnightSurfaceBiomes.FUNGI_FOREST || biome == MidnightSurfaceBiomes.HILLY_FUNGI_FOREST) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 2 : 3));
            } else if (biome == MidnightSurfaceBiomes.CRYSTAL_SPIRES) {
                this.setAntlerType(random == 0 ? 5 : 6);
            } else if (biome == MidnightSurfaceBiomes.PHANTASMAL_VALLEY || biome == MidnightSurfaceBiomes.OBSCURED_PEAKS || biome == MidnightSurfaceBiomes.OBSCURED_PLATEAU || biome == MidnightSurfaceBiomes.BLACK_RIDGE) {
                this.setAntlerType(random == 0 ? 0 : (random == 1 ? 5 : 7));
            } else {
                this.setAntlerType(this.field_70146_Z.nextInt(9));
            }
        } else {
            this.setAntlerType(this.field_70146_Z.nextInt(9));
        }
        return livingdata;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANTLER_TYPE, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("antler_type", this.getAntlerType());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("antler_type", 3)) {
            int antlerType = compound.func_74762_e("antler_type");
            this.setAntlerType(antlerType >= 0 && antlerType < 9 ? antlerType : 0);
        }
    }

    public void setAntlerType(int antlerType) {
        this.field_70180_af.func_187227_b(ANTLER_TYPE, (Object)(antlerType >= 0 && antlerType < 9 ? antlerType : 0));
    }

    public int getAntlerType() {
        return (Integer)this.field_70180_af.func_187225_a(ANTLER_TYPE);
    }

    public boolean func_70617_f_() {
        return false;
    }

    protected float func_70599_aP() {
        return 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return MidnightSounds.NIGHTSTAG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MidnightSounds.NIGHTSTAG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MidnightSounds.NIGHTSTAG_DEATH;
    }

    public int func_70627_aG() {
        return 200;
    }

    protected void func_180429_a(BlockPos pos, BlockState stateIn) {
        this.func_184185_a(MidnightSounds.NIGHTSTAG_STEP, 0.15f, 1.0f);
    }

    public float func_180484_a(BlockPos pos) {
        Block belowBlock = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        return belowBlock == MidnightBlocks.GRASS_BLOCK || belowBlock == MidnightBlocks.NIGHTSTONE ? 10.0f : 9.0f - this.field_70170_p.func_205052_D(pos) * 10.0f;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        if (this.func_180425_c().func_177956_o() <= worldIn.func_181545_F()) {
            return false;
        }
        return super.func_213380_a(worldIn, spawnReasonIn);
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundPathNavigator((MobEntity)this, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new NeutralGoal((CreatureEntity)this, (Goal)new PanicGoal((CreatureEntity)this, 1.2), true));
        this.field_70714_bg.func_75776_a(1, (Goal)new NeutralGoal((CreatureEntity)this, new ChargeGoal((MobEntity)this, 1.2, 200, 0.25f), false));
        this.field_70714_bg.func_75776_a(2, (Goal)new NeutralGoal((CreatureEntity)this, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false), false));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.0, Ingredient.field_193370_a, false){

            protected boolean func_188508_a(ItemStack stack) {
                return NightStagEntity.this.func_70877_b(stack);
            }

            public boolean func_75250_a() {
                boolean valid = super.func_75250_a();
                if (valid && !this.field_75289_h.func_184812_l_() && --NightStagEntity.this.temptTime < 0) {
                    NightStagEntity.this.temptTime = 400;
                    NightStagEntity.this.func_70624_b((LivingEntity)this.field_75289_h);
                }
                return valid;
            }
        });
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SearchForBlockGoal((CreatureEntity)this, FRUIT_PREDICATE, 0.7, 8, 200));
        this.field_70714_bg.func_75776_a(5, (Goal)new EatGrassGoal((MobEntity)this, 40, false, FRUIT_PREDICATE){

            @Override
            public boolean func_75250_a() {
                BlockPos currentPos;
                return super.func_75250_a() || (currentPos = NightStagEntity.this.func_180425_c()).equals((Object)NightStagEntity.this.func_213384_dI()) && FRUIT_PREDICATE.test(NightStagEntity.this.field_70170_p.func_180495_p(currentPos));
            }

            @Override
            protected void eatPlant(BlockState state, BlockPos pos) {
                this.owner.field_70170_p.func_180501_a(pos, (BlockState)MidnightBlocks.UNSTABLE_BUSH.func_176223_P().func_206870_a((IProperty)UnstableBushBlock.STAGE, (Comparable)Integer.valueOf(4)), 2);
                if (NightStagEntity.this.func_70631_g_()) {
                    NightStagEntity.this.func_70873_a(Math.min(NightStagEntity.this.func_70874_b() + 5000, 0));
                }
                NightStagEntity.this.func_195064_c(new EffectInstance(Effects.field_188424_y, 200, 0, false, true));
                NightStagEntity.this.func_195064_c(new EffectInstance(MidnightEffects.UNSTABLE_FALL, 400, 0, false, true));
            }
        });
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.7, 0.005f));
        this.field_70714_bg.func_75776_a(7, (Goal)new CurtseyGoal((MobEntity)this, PlayerEntity.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NeutralGoal((CreatureEntity)this, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{NightStagEntity.class}), false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
    }

    protected void func_175500_n() {
        IAttributeInstance attackAttrib = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        if (attackAttrib.func_180374_a(CHILD_ATTACK_MALUS)) {
            attackAttrib.func_111124_b(CHILD_ATTACK_MALUS);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(1.0);
        this.func_70606_j(20.0f);
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag;
        super.func_70652_k(entity);
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (this.animCap.getAnimationType() == AnimationCapability.Type.CHARGE) {
            damage *= 2.0f;
        }
        if (flag = entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) {
            if (!this.func_70631_g_() && entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_195064_c(new EffectInstance(MidnightEffects.DARKNESS, 200, 0, false, true));
            }
            this.func_174815_a((LivingEntity)this, entity);
            this.animCap.setAnimation((Entity)this, AnimationCapability.Type.ATTACK, 10);
        }
        return flag;
    }

    public void func_184609_a(Hand hand) {
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return super.func_225503_b_(distance, damageMultiplier * 0.2f);
    }

    public double func_70042_X() {
        return (double)super.func_213302_cg() * 0.9;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() instanceof UnstableFruitItem;
    }

    protected void func_175505_a(PlayerEntity player, ItemStack stack) {
        if (this.func_70877_b(stack)) {
            this.temptTime = 400;
            this.func_195064_c(new EffectInstance(Effects.field_188424_y, 200, 0, false, true));
            this.func_195064_c(new EffectInstance(MidnightEffects.UNSTABLE_FALL, 400, 0, false, true));
        }
        super.func_175505_a(player, stack);
    }

    public void func_70615_aA() {
        this.func_70691_i(1.0f);
    }

    protected int func_70693_a(PlayerEntity player) {
        return this.func_70631_g_() ? 4 : 7;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == MidnightBlocks.GRASS_BLOCK ? 10.0f : 1.0f;
    }

    public void func_70636_d() {
        IAttributeInstance attackAttrib;
        super.func_70636_d();
        this.animCap.updateAnimation();
        if (!this.field_70170_p.field_72995_K && this.func_70631_g_() && !(attackAttrib = this.func_110148_a(SharedMonsterAttributes.field_111264_e)).func_180374_a(CHILD_ATTACK_MALUS)) {
            attackAttrib.func_111121_a(CHILD_ATTACK_MALUS);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
            this.func_70606_j(10.0f);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        return capability == Midnight.ANIMATION_CAP ? LazyOptional.of(() -> this.animCap).cast() : LazyOptional.empty();
    }

    public class CurtseyGoal
    extends LookAtGoal {
        CurtseyGoal(MobEntity entity, Class<? extends LivingEntity> watchTargetClass, float maxDistance, float chance) {
            super(entity, watchTargetClass, maxDistance, chance);
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (!NightStagEntity.this.func_70631_g_() && NightStagEntity.this.func_70638_az() == null && NightStagEntity.this.func_70681_au().nextFloat() < 0.1f) {
                if (this.field_75334_a instanceof ServerPlayerEntity && MidnightUtil.isNotFakePlayer(this.field_75334_a)) {
                    MidnightCriterion.NIGHTSTAG_BOW[NightStagEntity.this.getAntlerType()].trigger((ServerPlayerEntity)this.field_75334_a);
                }
                NightStagEntity.this.animCap.setAnimation((Entity)this.field_75332_b, AnimationCapability.Type.CURTSEY, 40);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            if (NightStagEntity.this.animCap.isAnimate()) {
                NightStagEntity.this.animCap.resetAnimation((Entity)this.field_75332_b);
            }
        }
    }
}

