/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.creature;

import com.mushroom.midnight.Midnight;
import com.mushroom.midnight.common.capability.RifterCapturable;
import com.mushroom.midnight.common.entity.TargetIdleTracker;
import com.mushroom.midnight.common.entity.task.RifterCaptureGoalGoal;
import com.mushroom.midnight.common.entity.task.RifterMeleeGoal;
import com.mushroom.midnight.common.entity.task.RifterReturnGoal;
import com.mushroom.midnight.common.entity.task.RifterTeleportGoal;
import com.mushroom.midnight.common.entity.util.DragSolver;
import com.mushroom.midnight.common.event.RifterCaptureEvent;
import com.mushroom.midnight.common.event.RifterReleaseEvent;
import com.mushroom.midnight.common.network.CaptureEntityMessage;
import com.mushroom.midnight.common.registry.MidnightEffects;
import com.mushroom.midnight.common.registry.MidnightSounds;
import com.mushroom.midnight.common.util.MidnightUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtWithoutMovingGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.PacketDistributor;

public class RifterEntity
extends MonsterEntity
implements IEntityAdditionalSpawnData {
    public static final float HOME_SCALE_MODIFIER = 1.4f;
    private static final UUID SPEED_MODIFIER_ID = UUID.fromString("3b8cda1f-c11d-478b-98b1-6144940c7ba1");
    private static final AttributeModifier HOME_SPEED_MODIFIER = new AttributeModifier(SPEED_MODIFIER_ID, "home_speed_modifier", 0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final UUID ARMOR_MODIFIER_ID = UUID.fromString("8cea53c5-1b5c-4b7c-9c86-192bf255c3d4");
    private static final AttributeModifier HOME_ARMOR_MODIFIER = new AttributeModifier(ARMOR_MODIFIER_ID, "home_armor_modifier", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final UUID ATTACK_MODIFIER_ID = UUID.fromString("0e13d84c-52ed-4335-a284-49596533f445");
    private static final AttributeModifier HOME_ATTACK_MODIFIER = new AttributeModifier(ATTACK_MODIFIER_ID, "home_attack_modifier", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final int CAPTURE_COOLDOWN = 15;
    private static final double RIFT_SEARCH_RADIUS = 48.0;
    private static final float DROP_DAMAGE_THRESHOLD = 2.0f;
    private BlockPos riftPosition;
    private final DragSolver dragSolver;
    private final TargetIdleTracker targetIdleTracker = new TargetIdleTracker((MobEntity)this, 3.0);
    public int captureCooldown;
    public boolean spawnedThroughRift;
    private LivingEntity capturedEntity;
    private float scaleModifier;

    public RifterEntity(EntityType<? extends RifterEntity> entityType, World world) {
        super(entityType, world);
        this.dragSolver = new DragSolver(this);
        this.scaleModifier = MidnightUtil.isMidnightDimension(world) ? 1.4f : 1.0f;
        this.field_70138_W = 1.0f;
    }

    public float func_213355_cm() {
        return this.scaleModifier;
    }

    public float func_213307_e(Pose pose) {
        return super.func_213307_e(pose) * this.scaleModifier;
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn);
    }

    protected PathNavigator func_175447_b(World world) {
        return new GroundPathNavigator((MobEntity)this, world);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return this.func_180425_c().func_177956_o() > this.field_70170_p.func_181545_F();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new RifterReturnGoal(this, 1.3));
        this.field_70714_bg.func_75776_a(1, (Goal)new RifterTeleportGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RifterCaptureGoalGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new RifterMeleeGoal(this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new OpenDoorGoal((MobEntity)this, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtWithoutMovingGoal((MobEntity)this, LivingEntity.class, 8.0f, 0.2f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.4, 0.005f));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 2, true, false, this::shouldAttack));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 4, true, false, this::shouldAttack));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(38.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
    }

    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            this.targetIdleTracker.update();
            this.applyHomeModifier(SharedMonsterAttributes.field_111263_d, HOME_SPEED_MODIFIER);
            this.applyHomeModifier(SharedMonsterAttributes.field_111264_e, HOME_ATTACK_MODIFIER);
            this.applyHomeModifier(SharedMonsterAttributes.field_188791_g, HOME_ARMOR_MODIFIER);
            if (this.capturedEntity != null && !this.capturedEntity.func_70089_S()) {
                this.setCapturedEntity(null);
            }
            if (this.captureCooldown > 0) {
                --this.captureCooldown;
            }
        }
        if (!this.field_70170_p.field_72995_K || Midnight.PROXY.isClientPlayer((Entity)this.capturedEntity)) {
            this.dragSolver.solveDrag();
        }
        super.func_70636_d();
    }

    public int getTargetIdleTime() {
        return this.targetIdleTracker.getIdleTime();
    }

    public boolean shouldCapture() {
        return !MidnightUtil.isMidnightDimension(this.field_70170_p);
    }

    private void applyHomeModifier(IAttribute attribute, AttributeModifier modifier) {
        IAttributeInstance instance = this.func_110148_a(attribute);
        boolean home = MidnightUtil.isMidnightDimension(this.field_70170_p);
        if (home != instance.func_180374_a(modifier)) {
            if (home) {
                instance.func_111121_a(modifier);
            } else {
                instance.func_111124_b(modifier);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        Entity trueSource = source.func_76346_g();
        if (super.func_70097_a(source, amount)) {
            if (trueSource instanceof LivingEntity && this.shouldAttack(trueSource) && this.shouldChangeTarget(this.func_70638_az(), (LivingEntity)trueSource)) {
                this.func_70624_b((LivingEntity)trueSource);
            }
            if (amount > 2.0f) {
                this.setCapturedEntity(null);
            }
            return true;
        }
        return false;
    }

    protected float func_70599_aP() {
        return 1.5f;
    }

    private boolean shouldAttack(Entity entity) {
        if (entity == null || RifterCapturable.isCaptured(entity)) {
            return false;
        }
        if (entity instanceof AnimalEntity) {
            return !MidnightUtil.isMidnightDimension(entity.field_70170_p);
        }
        if (entity instanceof PlayerEntity && ((PlayerEntity)entity).func_70608_bn()) {
            return false;
        }
        return !(entity instanceof RifterEntity);
    }

    private boolean shouldChangeTarget(@Nullable LivingEntity from, LivingEntity to) {
        if (from == null) {
            return true;
        }
        if (to instanceof PlayerEntity && !(from instanceof PlayerEntity)) {
            return true;
        }
        return to.func_110143_aJ() > from.func_110143_aJ();
    }

    public void setCapturedEntity(@Nullable LivingEntity capturedEntity) {
        this.captureCooldown = 15;
        if (MinecraftForge.EVENT_BUS.post((Event)new RifterReleaseEvent(this, this.capturedEntity))) {
            return;
        }
        if (this.capturedEntity != null) {
            this.resetCapturedEntity(this.capturedEntity);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new RifterCaptureEvent(this, capturedEntity))) {
            return;
        }
        this.capturedEntity = capturedEntity;
        this.dragSolver.setDragged(capturedEntity);
        if (capturedEntity != null) {
            this.initCapturedEntity(capturedEntity);
        }
        if (!this.field_70170_p.field_72995_K) {
            CaptureEntityMessage message = new CaptureEntityMessage(this, capturedEntity);
            Midnight.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)message);
        }
    }

    private void initCapturedEntity(LivingEntity capturedEntity) {
        capturedEntity.getCapability(Midnight.RIFTER_CAPTURABLE_CAP, null).ifPresent(capturable -> capturable.setCaptured(true));
        capturedEntity.func_195064_c(new EffectInstance(MidnightEffects.STUNNED, 200, 1, false, false));
        capturedEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 400, 2, false, false));
    }

    private void resetCapturedEntity(LivingEntity capturedEntity) {
        capturedEntity.getCapability(Midnight.RIFTER_CAPTURABLE_CAP, null).ifPresent(capturable -> capturable.setCaptured(false));
    }

    public LivingEntity getCapturedEntity() {
        return this.capturedEntity;
    }

    public boolean hasCaptured() {
        return this.capturedEntity != null;
    }

    public DragSolver getDragSolver() {
        return this.dragSolver;
    }

    public int func_70641_bl() {
        return 1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return MidnightSounds.RIFTER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return MidnightSounds.RIFTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MidnightSounds.RIFTER_DEATH;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.riftPosition != null) {
            compound.func_218657_a("home_rift", (INBT)NBTUtil.func_186859_a((BlockPos)this.riftPosition));
        }
        compound.func_74757_a("spawned_through_rift", this.spawnedThroughRift);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.riftPosition = null;
        if (compound.func_74764_b("home_rift")) {
            this.riftPosition = NBTUtil.func_186861_c((CompoundNBT)compound.func_74775_l("home_rift"));
        }
        this.spawnedThroughRift = compound.func_74767_n("spawned_through_rift");
    }

    public void setRiftPosition(BlockPos riftPosition) {
        this.riftPosition = riftPosition;
    }

    public BlockPos getRiftPosition() {
        return this.riftPosition;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.capturedEntity != null ? this.capturedEntity.func_145782_y() : -1);
    }

    public void readSpawnData(PacketBuffer buffer) {
        Entity entity;
        int capturedId = buffer.readInt();
        if (capturedId != -1 && (entity = this.field_70170_p.func_73045_a(capturedId)) instanceof LivingEntity) {
            this.setCapturedEntity((LivingEntity)entity);
        }
    }
}

