/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.task;

import com.mushroom.midnight.common.config.MidnightConfig;
import com.mushroom.midnight.common.entity.creature.RifterEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class RifterTeleportGoal
extends Goal {
    private static final double MAX_DISTANCE_SQ = 576.0;
    private static final int MIN_IDLE_TIME = 40;
    private final RifterEntity owner;

    public RifterTeleportGoal(RifterEntity owner) {
        this.owner = owner;
    }

    public boolean func_75250_a() {
        if (!((Boolean)MidnightConfig.logic.allowRifterTeleport.get()).booleanValue() || this.owner.func_70681_au().nextInt(10) != 0) {
            return false;
        }
        LivingEntity target = this.owner.func_70638_az();
        if (target == null || this.owner.getTargetIdleTime() < 40) {
            return false;
        }
        double distanceSq = target.func_70068_e((Entity)this.owner);
        return distanceSq < 576.0 && !this.canBeSeen();
    }

    public void func_75249_e() {
        LivingEntity attackTarget = this.owner.func_70638_az();
        if (attackTarget == null) {
            return;
        }
        BlockPos target = this.computeTeleportTarget(attackTarget);
        if (target != null) {
            this.owner.field_70177_z = attackTarget.field_70177_z;
            this.owner.func_70634_a((double)target.func_177958_n() + 0.5, target.func_177956_o(), (double)target.func_177952_p() + 0.5);
            this.owner.func_70642_aH();
            this.owner.func_70661_as().func_75499_g();
        }
    }

    private BlockPos computeTeleportTarget(LivingEntity target) {
        BlockPos origin = target.func_180425_c();
        ArrayList<BlockPos> validPositions = new ArrayList<BlockPos>();
        for (int i = 0; i < 6; ++i) {
            double d0 = (double)origin.func_177958_n() + (this.owner.func_70681_au().nextDouble() - 0.5) * 12.0;
            double d1 = (double)origin.func_177956_o() + (double)(this.owner.func_70681_au().nextInt(12) - 6);
            double d2 = (double)origin.func_177952_p() + (this.owner.func_70681_au().nextDouble() - 0.5) * 12.0;
            Vec3d vector = new Vec3d(d0, d1, d2);
            BlockPos pos = new BlockPos(d0, d1, d2);
            if (this.canBeSeenBy(vector, target) || !this.isTargetValid(pos) || !this.isCanTeleport(pos, target)) continue;
            validPositions.add(new BlockPos((Vec3i)pos));
        }
        if (validPositions.isEmpty()) {
            return null;
        }
        return (BlockPos)validPositions.get(this.owner.func_70681_au().nextInt(validPositions.size()));
    }

    private boolean isCanTeleport(BlockPos pos, LivingEntity target) {
        BlockState blockstate = this.owner.field_70170_p.func_180495_p(pos);
        boolean flag = blockstate.func_185904_a().func_76230_c();
        boolean flag1 = blockstate.func_204520_s().func_206884_a(FluidTags.field_206959_a);
        if (flag && !flag1 && this.owner.field_70170_p.func_217298_h(pos) < 7) {
            return target.func_70092_e((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > 8.0;
        }
        return false;
    }

    private boolean isTargetValid(BlockPos target) {
        if (this.owner.field_70170_p.func_72829_c(this.getEntityBoundAt((Entity)this.owner, target))) {
            return false;
        }
        return this.owner.func_70661_as().func_179680_a(target, 0) != null;
    }

    private AxisAlignedBB getEntityBoundAt(Entity entity, BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = pos.func_177956_o();
        double z = (double)pos.func_177952_p() + 0.5;
        float halfWidth = entity.func_213311_cf() / 2.0f;
        return new AxisAlignedBB(x - (double)halfWidth, y, z - (double)halfWidth, x + (double)halfWidth, y + (double)entity.func_213302_cg(), z + (double)halfWidth);
    }

    public boolean func_75253_b() {
        return false;
    }

    private boolean canBeSeen() {
        List players = this.owner.field_70170_p.func_217357_a(PlayerEntity.class, this.owner.func_174813_aQ().func_186662_g(24.0));
        for (PlayerEntity player : players) {
            if (!this.canBeSeenBy(this.owner.func_174791_d(), (LivingEntity)player)) continue;
            return true;
        }
        return false;
    }

    private boolean canBeSeenBy(Vec3d position, LivingEntity entity) {
        Vec3d playerLook = entity.func_70676_i(1.0f);
        Vec3d deltaPos = entity.func_174791_d().func_178788_d(position);
        return playerLook.func_72430_b(deltaPos = deltaPos.func_72432_b()) < 0.0;
    }
}

