/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.entity.util;

import com.mushroom.midnight.common.entity.util.TransformationMethod;
import com.mushroom.midnight.common.util.MatrixStack;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChainSolver<E extends LivingEntity> {
    private final Quaternion rootNode;
    private final Quaternion[] restingPoints;
    private final Quaternion[] transformedRestingPoints;
    private final Quaternion[] solvedNodes;
    private final Quaternion[] previousNodes;
    private final Vector3f[] nodeVelocity;
    private final float tightness;
    private final float dampening;
    private final TransformationMethod<E> transformationMethod;
    private final MatrixStack matrix = new MatrixStack(4);

    public ChainSolver(Quaternion rootNode, Quaternion[] restingPoints, float tightness, float dampening, TransformationMethod<E> transformationMethod) {
        this.rootNode = rootNode;
        this.restingPoints = this.relativize(restingPoints);
        this.tightness = tightness;
        this.dampening = dampening;
        this.transformedRestingPoints = new Quaternion[restingPoints.length];
        this.solvedNodes = new Quaternion[restingPoints.length];
        this.previousNodes = new Quaternion[restingPoints.length];
        this.nodeVelocity = new Vector3f[restingPoints.length];
        for (int i = 0; i < this.restingPoints.length; ++i) {
            this.transformedRestingPoints[i] = new Quaternion(this.restingPoints[i]);
            this.solvedNodes[i] = Quaternion.field_227060_a_;
            this.previousNodes[i] = Quaternion.field_227060_a_;
            this.nodeVelocity[i] = new Vector3f();
        }
        this.transformationMethod = transformationMethod;
    }

    private Quaternion[] relativize(Quaternion[] restingPoints) {
        for (int i = restingPoints.length - 1; i >= 1; --i) {
            Quaternion point = restingPoints[i];
            Quaternion previousPoint = restingPoints[i - 1];
            point.func_227066_a_(point.func_195889_a() - previousPoint.func_195889_a(), point.func_195891_b() - previousPoint.func_195891_b(), point.func_195893_c() - previousPoint.func_195893_c(), point.func_195894_d());
        }
        return restingPoints;
    }

    public void update(E entity) {
        this.computeTransforms(entity);
        this.storePreviousState();
        for (int i = 0; i < this.restingPoints.length; ++i) {
            Quaternion restingPoint = this.transformedRestingPoints[i];
            Quaternion previousPoint = i > 0 ? this.transformedRestingPoints[i - 1] : this.rootNode;
            Quaternion currentPoint = this.solvedNodes[i];
            float localX = currentPoint.func_195889_a() - previousPoint.func_195889_a();
            float localY = currentPoint.func_195891_b() - previousPoint.func_195891_b();
            float localZ = currentPoint.func_195893_c() - previousPoint.func_195893_c();
            Vector3f nodeVelocity = this.nodeVelocity[i];
            nodeVelocity.func_195905_a(nodeVelocity.func_195899_a() * this.dampening, nodeVelocity.func_195900_b() * this.dampening, nodeVelocity.func_195902_c() * this.dampening);
            nodeVelocity.func_195904_b(this.tightness * (restingPoint.func_195889_a() - localX), this.tightness * (restingPoint.func_195891_b() - localY), this.tightness * (restingPoint.func_195893_c() - localZ));
            currentPoint.func_227066_a_(currentPoint.func_195889_a() + nodeVelocity.func_195899_a(), currentPoint.func_195891_b() + nodeVelocity.func_195900_b(), currentPoint.func_195893_c() + nodeVelocity.func_195902_c(), currentPoint.func_195894_d());
        }
    }

    private void computeTransforms(E entity) {
        this.matrix.getLast().getNormalMatrix().func_226119_c_();
        this.transformationMethod.transform(entity, this.matrix);
        for (int i = 0; i < this.restingPoints.length; ++i) {
            Quaternion restingPoint = this.restingPoints[i];
            Quaternion transformedPoint = this.transformedRestingPoints[i];
            transformedPoint.func_227066_a_(restingPoint.func_195889_a(), restingPoint.func_195891_b(), restingPoint.func_195893_c(), restingPoint.func_195894_d());
            this.matrix.transform(transformedPoint);
        }
    }

    private void storePreviousState() {
        for (int i = 0; i < this.solvedNodes.length; ++i) {
            this.previousNodes[i].func_227066_a_(this.solvedNodes[i].func_195889_a(), this.solvedNodes[i].func_195891_b(), this.solvedNodes[i].func_195893_c(), this.solvedNodes[i].func_195894_d());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void apply(ModelRenderer[] parts, float partialTicks) {
        if (parts.length != this.solvedNodes.length) {
            throw new IllegalArgumentException("Expected " + this.solvedNodes.length + " parts but got " + parts.length);
        }
        for (int i = 0; i < this.solvedNodes.length; ++i) {
            Quaternion solvedNode = this.solvedNodes[i];
            Quaternion connectedNode = i > 1 ? this.solvedNodes[i] : this.rootNode;
            float deltaX = solvedNode.func_195889_a() - connectedNode.func_195889_a();
            float deltaY = solvedNode.func_195891_b() - connectedNode.func_195891_b();
            float deltaZ = solvedNode.func_195893_c() - connectedNode.func_195893_c();
            float distanceHorizontal = MathHelper.func_76129_c((float)(deltaX * deltaX + deltaZ * deltaZ));
            ModelRenderer part = parts[i];
            part.field_78796_g = (float)(Math.atan2(deltaZ, deltaX) - 1.5707963267948966);
            part.field_78795_f = (float)Math.atan2(deltaY, distanceHorizontal);
        }
    }
}

