/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.item.tool;

import com.mushroom.midnight.common.item.tool.MidnightFluidBucketWrapper;
import com.mushroom.midnight.common.registry.MidnightFluids;
import com.mushroom.midnight.common.registry.MidnightItems;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;

public class RockShroomBucketItem
extends BucketItem {
    private final Fluid containedBlock;

    public RockShroomBucketItem(Supplier<? extends Fluid> supplier, Item.Properties builder) {
        super(supplier, builder);
        this.containedBlock = supplier.get();
    }

    protected ItemStack func_203790_a(ItemStack p_203790_1_, PlayerEntity p_203790_2_) {
        return !p_203790_2_.field_71075_bZ.field_75098_d ? new ItemStack((IItemProvider)MidnightItems.ROCKSHROOM_BUCKET) : p_203790_1_;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        RayTraceResult raytraceresult;
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)itemstack, (RayTraceResult)(raytraceresult = RockShroomBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.containedBlock == Fluids.field_204541_a ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE))));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)itemstack);
        }
        BlockRayTraceResult blockraytraceresult = (BlockRayTraceResult)raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        Direction direction = blockraytraceresult.func_216354_b();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos1, direction, itemstack)) {
            BlockPos blockpos2;
            if (this.containedBlock == Fluids.field_204541_a) {
                Fluid fluid;
                BlockState blockstate1 = worldIn.func_180495_p(blockpos);
                if (blockstate1.func_177230_c() instanceof IBucketPickupHandler && (fluid = ((IBucketPickupHandler)blockstate1.func_177230_c()).func_204508_a((IWorld)worldIn, blockpos, blockstate1)) != Fluids.field_204541_a) {
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent soundevent = this.containedBlock.getAttributes().getEmptySound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a(FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                    ItemStack itemstack1 = this.fillBucket(itemstack, playerIn, RockShroomBucketItem.getFilledBucket(fluid).func_77973_b());
                    if (!worldIn.field_72995_K) {
                        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)RockShroomBucketItem.getFilledBucket(fluid).func_77973_b()));
                    }
                    return ActionResult.func_226248_a_((Object)itemstack1);
                }
                return ActionResult.func_226251_d_((Object)itemstack);
            }
            BlockState blockstate = worldIn.func_180495_p(blockpos);
            BlockPos blockPos = blockpos2 = blockstate.func_177230_c() instanceof ILiquidContainer && this.containedBlock == Fluids.field_204546_a ? blockpos : blockpos1;
            if (this.func_180616_a(playerIn, worldIn, blockpos2, blockraytraceresult)) {
                this.func_203792_a(worldIn, itemstack, blockpos2);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos2, itemstack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_226248_a_((Object)this.func_203790_a(itemstack, playerIn));
            }
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        return ActionResult.func_226251_d_((Object)itemstack);
    }

    @Nonnull
    public static ItemStack getFilledBucket(@Nonnull Fluid fluid) {
        if (fluid == Fluids.field_204546_a) {
            return new ItemStack((IItemProvider)MidnightItems.WATER_ROCKSHROOM_BUCKET);
        }
        if (fluid == MidnightFluids.DARK_WATER) {
            return new ItemStack((IItemProvider)MidnightItems.DARKWATER_ROCKSHROOM_BUCKET);
        }
        return new ItemStack((IItemProvider)MidnightItems.DARKWATER_ROCKSHROOM_BUCKET);
    }

    private ItemStack fillBucket(ItemStack emptyBuckets, PlayerEntity player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBuckets;
        }
        emptyBuckets.func_190918_g(1);
        if (emptyBuckets.func_190926_b()) {
            return new ItemStack((IItemProvider)fullBucket);
        }
        if (!player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)fullBucket))) {
            player.func_71019_a(new ItemStack((IItemProvider)fullBucket), false);
        }
        return emptyBuckets;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (((Object)((Object)this)).getClass() == RockShroomBucketItem.class) {
            return new MidnightFluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }
}

