/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.registries.ForgeRegistries;

public class InBiomeLootCondition
implements ILootCondition {
    private final Biome requiredBiome;

    public InBiomeLootCondition(Biome requiredBiome) {
        this.requiredBiome = requiredBiome;
    }

    public boolean test(LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity == null) {
            return false;
        }
        Biome biome = context.func_202879_g().func_226691_t_(entity.func_180425_c());
        return biome == this.requiredBiome;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<InBiomeLootCondition> {
        public Serializer() {
            super(new ResourceLocation("midnight", "in_biome"), InBiomeLootCondition.class);
        }

        public void serialize(JsonObject json, InBiomeLootCondition value, JsonSerializationContext context) {
            json.addProperty("biome", value.requiredBiome.getRegistryName().toString());
        }

        public InBiomeLootCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            if (!json.has("biome")) {
                throw new JsonSyntaxException("Missing biome tag, expected to find a biome registry name");
            }
            ResourceLocation biomeResLoc = new ResourceLocation(json.get("biome").getAsString());
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(biomeResLoc);
            if (biome == null) {
                throw new JsonSyntaxException("Invalid biome tag. " + biomeResLoc + " does not exist in the biome registry.");
            }
            return new InBiomeLootCondition(biome);
        }
    }
}

