/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.tile;

import com.google.common.collect.Maps;
import com.mushroom.midnight.common.inventory.MidnightFurnaceContainer;
import com.mushroom.midnight.common.registry.MidnightItems;
import com.mushroom.midnight.common.registry.MidnightRecipeTypes;
import com.mushroom.midnight.common.registry.MidnightTileEntities;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class MidnightFurnaceTileEntity
extends AbstractFurnaceTileEntity {
    protected MidnightFurnaceTileEntity(TileEntityType<?> entityType) {
        super(entityType, MidnightRecipeTypes.SMELTING);
    }

    public MidnightFurnaceTileEntity() {
        this(MidnightTileEntities.MIDNIGHT_FURNACE);
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("block.midnight.nightstone_furnace", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new MidnightFurnaceContainer(id, player, (IInventory)this, this.field_214013_b);
    }

    public static Map<Item, Integer> getBurnTimes() {
        LinkedHashMap burnTimes = Maps.newLinkedHashMap();
        MidnightFurnaceTileEntity.addItemBurnTime(burnTimes, (IItemProvider)MidnightItems.DARK_PEARL, 1600);
        return burnTimes;
    }

    private static void addItemTagBurnTime(Map<Item, Integer> map, Tag<Item> tag, int burnTime) {
        for (Item item : tag.func_199885_a()) {
            map.put(item, burnTime);
        }
    }

    private static void addItemBurnTime(Map<Item, Integer> map, IItemProvider item, int burnTime) {
        map.put(item.func_199767_j(), burnTime);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 2) {
            return false;
        }
        if (index != 1) {
            return true;
        }
        ItemStack item = (ItemStack)this.field_214012_a.get(1);
        return MidnightFurnaceTileEntity.isFuel(stack) || stack.func_77973_b() == Items.field_151133_ar && item.func_77973_b() != Items.field_151133_ar;
    }

    protected int func_213997_a(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        return MidnightFurnaceTileEntity.getBurnTimes().getOrDefault(item, 0);
    }

    public static boolean isFuel(ItemStack item) {
        return MidnightFurnaceTileEntity.getBurnTimes().getOrDefault(item.func_77973_b(), 0) > 0;
    }
}

