/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.util;

import net.minecraft.nbt.CompoundNBT;

public class SlidingToggle {
    private final int length;
    private int rate = 1;
    private boolean state;
    private int timer;
    private int prevTimer;

    public SlidingToggle(int length) {
        this.length = length;
    }

    public SlidingToggle initialize(boolean state) {
        this.state = state;
        this.prevTimer = state ? this.length : 0;
        this.timer = this.prevTimer;
        return this;
    }

    public void update() {
        this.prevTimer = this.timer;
        this.timer = this.state ? Math.min(this.timer + this.rate, this.length) : Math.max(this.timer - this.rate, 0);
    }

    public void set(boolean state) {
        this.state = state;
    }

    public boolean get() {
        return this.state;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getTimer() {
        return this.timer;
    }

    public float getScale() {
        return (float)this.timer / (float)this.length;
    }

    public float getScale(float partialTicks) {
        float timer = (float)this.prevTimer + (float)(this.timer - this.prevTimer) * partialTicks;
        return timer / (float)this.length;
    }

    public CompoundNBT serialize(CompoundNBT compound) {
        compound.func_74757_a("state", this.state);
        compound.func_74777_a("timer", (short)this.timer);
        compound.func_74774_a("rate", (byte)this.rate);
        return compound;
    }

    public void deserialize(CompoundNBT compound) {
        this.state = compound.func_74767_n("state");
        this.timer = compound.func_74765_d("timer");
        this.rate = compound.func_74771_c("rate");
    }

    public String toString() {
        return "SlidingToggle{state=" + this.state + ", timer=" + this.timer + '}';
    }
}

