/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.biome.surface.SurfaceBiome;
import com.mushroom.midnight.common.util.MidnightUtil;
import com.mushroom.midnight.common.world.util.TickableLerpedValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="midnight", value={Dist.CLIENT})
public final class MidnightAtmosphereController {
    public static final MidnightAtmosphereController INSTANCE = new MidnightAtmosphereController();
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private static final double COLOR_LERP_SPEED = 0.002;
    private static final double FOG_LERP_SPEED = 3.0;
    private static final Vec3d LIGHTING_SKY_COLOR = new Vec3d(1.0, 0.35, 0.25);
    private static final Vec3d UNDERGROUND_SKY_COLOR = new Vec3d(0.1, 0.1, 0.2);
    private final TickableLerpedValue surfaceSkyRed = TickableLerpedValue.atSpeed(0.002);
    private final TickableLerpedValue surfaceSkyGreen = TickableLerpedValue.atSpeed(0.002);
    private final TickableLerpedValue surfaceSkyBlue = TickableLerpedValue.atSpeed(0.002);
    private final TickableLerpedValue fogStart = TickableLerpedValue.atSpeed(3.0);
    private final TickableLerpedValue fogEnd = TickableLerpedValue.atSpeed(3.0);

    private MidnightAtmosphereController() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !MidnightUtil.isMidnightDimension(player.field_70170_p)) {
            return;
        }
        INSTANCE.update((PlayerEntity)player);
    }

    private void update(PlayerEntity player) {
        int playerX = MathHelper.func_76128_c((double)player.func_226277_ct_());
        int playerZ = MathHelper.func_76128_c((double)player.func_226281_cx_());
        Chunk chunk = player.field_70170_p.func_72863_F().func_225313_a(playerX >> 4, playerZ >> 4);
        if (chunk == null || chunk.func_225549_i_() == null) {
            return;
        }
        Biome biome = chunk.func_225549_i_().func_225526_b_(playerX & 0xF, 0, (playerZ & 0xF) << 4);
        this.updateSkyColor(biome);
        this.updateFog(biome);
    }

    private void updateSkyColor(Biome biome) {
        int skyColor = biome.func_225529_c_();
        this.surfaceSkyRed.update((double)(skyColor >> 16 & 0xFF) / 255.0);
        this.surfaceSkyGreen.update((double)(skyColor >> 8 & 0xFF) / 255.0);
        this.surfaceSkyBlue.update((double)(skyColor & 0xFF) / 255.0);
    }

    private void updateFog(Biome biome) {
        float fogStart = 20.0f;
        float fogEnd = 200.0f;
        if (biome instanceof SurfaceBiome) {
            SurfaceBiome surfaceBiome = (SurfaceBiome)biome;
            fogStart = surfaceBiome.getFogStart();
            fogEnd = surfaceBiome.getFogEnd();
        }
        this.fogStart.update(fogStart);
        this.fogEnd.update(fogEnd);
    }

    public Vec3d computeSkyColor() {
        float partialTicks = CLIENT.func_184121_ak();
        double undergroundFactor = this.getUndergroundFactor();
        if (undergroundFactor >= 1.0) {
            return UNDERGROUND_SKY_COLOR;
        }
        Vec3d color = new Vec3d(this.surfaceSkyRed.get(partialTicks), this.surfaceSkyGreen.get(partialTicks), this.surfaceSkyBlue.get(partialTicks));
        color = MidnightUtil.lerp(color, UNDERGROUND_SKY_COLOR, undergroundFactor);
        if (MidnightAtmosphereController.CLIENT.field_71441_e != null && MidnightAtmosphereController.CLIENT.field_71441_e.func_228332_n_() > 0) {
            color = MidnightUtil.lerp(color, LIGHTING_SKY_COLOR, 1.0 - undergroundFactor);
        }
        return color;
    }

    public double getFogStart() {
        double surface = this.fogStart.get(CLIENT.func_184121_ak());
        double underground = 20.0;
        return surface + (underground - surface) * this.getUndergroundFactor();
    }

    public double getFogEnd() {
        double surface = this.fogEnd.get(CLIENT.func_184121_ak());
        double underground = 200.0;
        return surface + (underground - surface) * this.getUndergroundFactor();
    }

    public double getUndergroundFactor() {
        ActiveRenderInfo renderInfo = MidnightAtmosphereController.CLIENT.field_71460_t.func_215316_n();
        double cameraY = renderInfo.func_216785_c().field_72448_b;
        return MathHelper.func_151237_a((double)((60.0 - cameraY) / 20.0), (double)0.0, (double)1.0);
    }
}

