/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world;

import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.registry.MidnightDimensions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;

public class MidnightTeleporter {
    public static final MidnightTeleporter INSTANCE = new MidnightTeleporter();

    private MidnightTeleporter() {
    }

    public void teleport(Entity entity) {
        MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
        if (server == null) {
            return;
        }
        DimensionType endpointDimension = this.getEndpointDimension(entity.field_71093_bK);
        ServerWorld endpointWorld = server.func_71218_a(endpointDimension);
        BlockPos entPos = entity.func_180425_c();
        BlockPos pos = new BlockPos(entPos.func_177958_n() + endpointWorld.field_73012_v.nextInt(15) - endpointWorld.field_73012_v.nextInt(15), entPos.func_177956_o(), entPos.func_177952_p() + endpointWorld.field_73012_v.nextInt(15) - endpointWorld.field_73012_v.nextInt(15));
        IChunk chunk = endpointWorld.func_217349_x(pos);
        int surfaceY = chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, pos.func_177958_n(), pos.func_177952_p()) + 1;
        BlockPos portalPos = new BlockPos(pos.func_177958_n(), surfaceY, pos.func_177952_p());
        Vec3d endpointPos = new Vec3d((double)pos.func_177958_n() + 0.5, (double)portalPos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        Entity teleportedEntity = this.teleportEntity(entity, endpointWorld, endpointPos);
        teleportedEntity.field_70143_R = 0.0f;
    }

    private BlockPos findPortal(ServerWorld world, BlockPos pos, int surfaceY) {
        BlockPos pos2 = new BlockPos(pos.func_177958_n(), surfaceY, pos.func_177952_p());
        for (int i = -20; i <= 5; ++i) {
            if (world.func_180495_p(pos2.func_177981_b(i)).func_177230_c() != MidnightBlocks.RIFT_PORTAL) continue;
            return pos2.func_177981_b(i + 1);
        }
        return null;
    }

    private Entity teleportEntity(Entity entity, ServerWorld endpointWorld, Vec3d endpoint) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            player.func_200619_a(endpointWorld, endpoint.field_72450_a, endpoint.field_72448_b, endpoint.field_72449_c, entity.field_70177_z, entity.field_70125_A);
            return player;
        }
        entity.func_213319_R();
        entity.field_71093_bK = endpointWorld.field_73011_w.func_186058_p();
        Entity teleportedEntity = entity.func_200600_R().func_200721_a((World)endpointWorld);
        if (teleportedEntity == null) {
            return entity;
        }
        teleportedEntity.func_180432_n(entity);
        teleportedEntity.func_70012_b(endpoint.field_72450_a, endpoint.field_72448_b, endpoint.field_72449_c, entity.field_70177_z, entity.field_70125_A);
        teleportedEntity.func_70034_d(entity.field_70177_z);
        endpointWorld.func_217460_e(teleportedEntity);
        entity.func_70106_y();
        return teleportedEntity;
    }

    private DimensionType getEndpointDimension(DimensionType source) {
        return source.getModType() == MidnightDimensions.MIDNIGHT ? DimensionType.field_223227_a_ : MidnightDimensions.midnight();
    }
}

