/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.block.MidnightDoublePlantBlock;
import com.mushroom.midnight.common.world.feature.tree.AbstractMidnightTreeFeature;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.FlowersFeature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class FungiPatchFeature
extends FlowersFeature<NoFeatureConfig> {
    private final BlockState fungi;
    private final BlockState tallFungi;
    private final AbstractMidnightTreeFeature<NoFeatureConfig> tree;

    public FungiPatchFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize, BlockState fungi, BlockState tallFungi, AbstractMidnightTreeFeature<NoFeatureConfig> tree) {
        super(deserialize);
        this.fungi = fungi;
        this.tallFungi = tallFungi;
        this.tree = tree;
    }

    public FungiPatchFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize, BlockState fungi, BlockState tallFungi) {
        this(deserialize, fungi, tallFungi, null);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random rand, BlockPos origin, NoFeatureConfig config) {
        boolean result = false;
        if (rand.nextFloat() < 0.05f && this.tree != null) {
            result |= this.tree.func_212245_a(world, generator, rand, origin, config);
        }
        float tallRatio = 0.3f;
        if (rand.nextFloat() < 0.2f) {
            tallRatio = 0.8f;
        }
        for (int i = 0; i < 20; ++i) {
            BlockPos pos = origin.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8));
            if (!world.func_175623_d(pos) || !this.fungi.func_196955_c((IWorldReader)world, pos)) continue;
            if (rand.nextFloat() < tallRatio) {
                MidnightDoublePlantBlock.placeAt(world, pos, this.tallFungi, 2);
            } else {
                world.func_180501_a(pos, this.fungi, 2);
            }
            result = true;
        }
        return result;
    }

    public boolean func_225559_a_(IWorld p_225559_1_, BlockPos p_225559_2_, NoFeatureConfig p_225559_3_) {
        return this.fungi == p_225559_1_.func_180495_p(p_225559_2_);
    }

    public int func_225560_a_(NoFeatureConfig p_225560_1_) {
        return 7;
    }

    public BlockPos getNearbyPos(Random p_225561_1_, BlockPos p_225561_2_, NoFeatureConfig p_225561_3_) {
        return p_225561_2_.func_177982_a(p_225561_1_.nextInt(3) - p_225561_1_.nextInt(3), p_225561_1_.nextInt(7) - p_225561_1_.nextInt(7), p_225561_1_.nextInt(3) - p_225561_1_.nextInt(3));
    }

    public BlockState getFlowerToPlace(Random p_225562_1_, BlockPos p_225562_2_, NoFeatureConfig p_225562_3_) {
        return this.fungi;
    }
}

