/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.world.feature.config.UniformCompositionConfig;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.Feature;

public class SpikeFeature
extends Feature<UniformCompositionConfig> {
    public SpikeFeature(Function<Dynamic<?>, ? extends UniformCompositionConfig> deserialize) {
        super(deserialize);
    }

    public boolean place(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, BlockPos origin, UniformCompositionConfig config) {
        while (world.func_175623_d(origin) && origin.func_177956_o() > 2) {
            origin = origin.func_177977_b();
        }
        origin = origin.func_177981_b(random.nextInt(4));
        int height = random.nextInt(4) + 7;
        int baseRadius = Math.max(height / 4 + random.nextInt(2), 2);
        for (int y = 0; y < height; ++y) {
            float radius = (1.0f - (float)y / (float)height) * (float)baseRadius;
            int bound = MathHelper.func_76123_f((float)radius);
            for (int x = -bound; x <= bound; ++x) {
                float deltaX = (float)MathHelper.func_76130_a((int)x) - 0.25f;
                for (int z = -bound; z <= bound; ++z) {
                    BlockPos inversePos;
                    float deltaZ = (float)MathHelper.func_76130_a((int)z) - 0.25f;
                    if ((x != 0 || z != 0) && !(deltaX * deltaX + deltaZ * deltaZ <= radius * radius) || (x == -bound || x == bound || z == -bound || z == bound) && !(random.nextFloat() <= 0.75f)) continue;
                    BlockPos pos = origin.func_177982_a(x, y, z);
                    if (this.canReplace(world, pos)) {
                        this.func_202278_a((IWorldWriter)world, pos, config.state);
                    }
                    if (y == 0 || bound <= 1 || !this.canReplace(world, inversePos = origin.func_177982_a(x, -y, z))) continue;
                    this.func_202278_a((IWorldWriter)world, inversePos, config.state);
                }
            }
        }
        return true;
    }

    private boolean canReplace(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockReader)world, pos) || state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b;
    }
}

