/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.placement;

import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.world.PlacementLevel;
import java.util.Objects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.Placement;

public class CountSurfaceDoublePlacement
extends Placement<FrequencyConfig> {
    private final PlacementLevel placementLevel;

    public CountSurfaceDoublePlacement(Function<Dynamic<?>, ? extends FrequencyConfig> deserialize, PlacementLevel placementLevel) {
        super(deserialize);
        this.placementLevel = placementLevel;
    }

    public Stream<BlockPos> getPositions(IWorld world, ChunkGenerator<? extends GenerationSettings> generator, Random random, FrequencyConfig config, BlockPos origin) {
        return IntStream.range(0, config.field_202476_a).mapToObj(i -> {
            int z;
            int x = random.nextInt(16);
            int maxY = this.placementLevel.getSurfacePos(world, Heightmap.Type.MOTION_BLOCKING, origin.func_177982_a(x, 0, z = random.nextInt(16))).func_177956_o() * 2;
            if (maxY <= 0) {
                return null;
            }
            int y = random.nextInt(maxY);
            if (!this.placementLevel.containsY(world, y)) {
                return null;
            }
            return origin.func_177982_a(x, y, z);
        }).filter(Objects::nonNull);
    }
}

