/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.feature.tree;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import com.mushroom.midnight.common.registry.MidnightBlocks;
import com.mushroom.midnight.common.world.feature.tree.MidnightTreeFeature;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class ShadowrootTreeFeature
extends MidnightTreeFeature {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final BlockState LOG = MidnightBlocks.SHADOWROOT_LOG.func_176223_P();
    private static final BlockState LEAVES = MidnightBlocks.SHADOWROOT_LEAVES.func_176223_P();
    private static final int BRANCH_SPACING = 3;

    public ShadowrootTreeFeature(Function<Dynamic<?>, ? extends NoFeatureConfig> deserialize) {
        super(deserialize);
        this.setSapling((IPlantable)MidnightBlocks.SHADOWROOT_SAPLING);
    }

    @Override
    protected boolean place(IWorld world, Random random, BlockPos origin) {
        int height = random.nextInt(8) + 10;
        if (!this.canFit(world, origin, 1, height)) {
            return false;
        }
        if (ShadowrootTreeFeature.isSoil((IWorldGenerationBaseReader)world, origin.func_177977_b(), this.getSapling())) {
            this.setDirtAt((IWorldGenerationReader)world, origin.func_177977_b(), origin);
            BlockPos.Mutable mutablePos = new BlockPos.Mutable(origin);
            for (int localY = 0; localY < height; ++localY) {
                mutablePos.func_185336_p(origin.func_177956_o() + localY);
                this.func_202278_a((IWorldWriter)world, (BlockPos)mutablePos, LOG);
            }
            this.generateRoots((IWorldGenerationReader)world, random, origin);
            Set<Branch> branches = this.collectBranches((IWorldGenerationReader)world, random, origin, height);
            for (Branch branch : branches) {
                this.func_202278_a((IWorldWriter)world, branch.pos, (BlockState)LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)branch.getAxis()));
            }
            Set<BlockPos> leafPositions = this.produceBlob(origin.func_177981_b(height - 2), 1.5, 2.5);
            leafPositions = this.droopLeaves(leafPositions, random, 4);
            for (Branch branch : branches) {
                leafPositions.addAll(this.collectBranchLeaves(branch, random));
            }
            for (BlockPos leafPos : leafPositions) {
                if (!ShadowrootTreeFeature.canGrowInto(world, leafPos)) continue;
                this.func_202278_a((IWorldWriter)world, leafPos, LEAVES);
            }
            return true;
        }
        return false;
    }

    private boolean canFit(IWorld world, BlockPos origin, int width, int height) {
        BlockPos min = origin.func_177982_a(-width, 0, -width);
        BlockPos max = origin.func_177982_a(width, height, width);
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            if (ShadowrootTreeFeature.canGrowInto(world, pos)) continue;
            return false;
        }
        return true;
    }

    private void generateRoots(IWorldGenerationReader world, Random random, BlockPos origin) {
        BlockPos.Mutable mutablePos = new BlockPos.Mutable();
        ArrayList availableSides = Lists.newArrayList((Object[])HORIZONTALS);
        int count = random.nextInt(3) + 1;
        for (int i = 0; i < count; ++i) {
            Direction side = (Direction)availableSides.remove(random.nextInt(availableSides.size()));
            BlockPos rootOrigin = origin.func_177972_a(side);
            int height = random.nextInt(3) + 1;
            for (int localY = 0; localY < height; ++localY) {
                mutablePos.func_181079_c(rootOrigin.func_177958_n(), rootOrigin.func_177956_o() + localY, rootOrigin.func_177952_p());
                this.func_202278_a((IWorldWriter)world, (BlockPos)mutablePos, LOG);
            }
        }
    }

    private Set<BlockPos> droopLeaves(Set<BlockPos> leafPositions, Random random, int amount) {
        HashSet<BlockPos> droopedLeaves = new HashSet<BlockPos>(leafPositions);
        for (BlockPos pos : leafPositions) {
            int droopAmount = random.nextInt(amount);
            for (int i = 0; i < droopAmount; ++i) {
                droopedLeaves.add(pos.func_177979_c(i));
            }
        }
        return droopedLeaves;
    }

    private Set<Branch> collectBranches(IWorldGenerationReader world, Random random, BlockPos origin, int height) {
        int minBranchHeight = 3;
        int maxBranchHeight = height - 4;
        int heightRange = maxBranchHeight - minBranchHeight;
        HashSet<Branch> branches = new HashSet<Branch>();
        int branchCount = heightRange / 3;
        double normalizedSpacing = (double)heightRange / (double)branchCount;
        Direction lastDirection = null;
        for (int branch = 0; branch < branchCount; ++branch) {
            int y = MathHelper.func_76143_f((double)((double)(minBranchHeight + 1) + (double)branch * normalizedSpacing));
            Direction direction = null;
            while (direction == null || direction == lastDirection) {
                direction = HORIZONTALS[random.nextInt(HORIZONTALS.length)];
            }
            lastDirection = direction;
            BlockPos branchPos = origin.func_177981_b(y).func_177972_a(direction);
            if (!ShadowrootTreeFeature.isAirOrLeaves((IWorldGenerationBaseReader)world, branchPos)) continue;
            float outerAngle = direction.func_185119_l();
            float angle = random.nextFloat() * 90.0f + outerAngle - 45.0f;
            branches.add(new Branch(branchPos, direction, angle));
        }
        return branches;
    }

    private Set<BlockPos> collectBranchLeaves(Branch branch, Random random) {
        HashSet<BlockPos> branchLeaves = new HashSet<BlockPos>();
        float theta = (float)Math.toRadians(branch.angle);
        float deltaX = -MathHelper.func_76126_a((float)theta);
        float deltaZ = MathHelper.func_76134_b((float)theta);
        for (int step = 0; step < 3; ++step) {
            int droop = -step / 2 + 1;
            BlockPos origin = branch.pos.func_177963_a((double)(deltaX * (float)step), (double)droop, (double)(deltaZ * (float)step));
            Set<BlockPos> stepLeaves = this.produceBlob(origin, 1.0);
            branchLeaves.addAll(this.droopLeaves(stepLeaves, random, step + 1));
        }
        return branchLeaves;
    }

    private static class Branch {
        final BlockPos pos;
        final Direction direction;
        final float angle;

        private Branch(BlockPos pos, Direction direction, float angle) {
            this.pos = pos;
            this.direction = direction;
            this.angle = angle;
        }

        public Direction.Axis getAxis() {
            return this.direction.func_176740_k();
        }

        public int hashCode() {
            return this.pos.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Branch && ((Branch)obj).pos.equals((Object)this.pos);
        }
    }
}

