/*
 * Decompiled with CFR 0.152.
 */
package com.mushroom.midnight.common.world.template;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mushroom.midnight.Midnight;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.registries.ForgeRegistries;

public class TemplateMarkers {
    private final Multimap<String, BlockPos> markers;
    private final Map<BlockPos, BlockState> replacements;

    private TemplateMarkers(Multimap<String, BlockPos> markers, Map<BlockPos, BlockState> replacements) {
        this.markers = markers;
        this.replacements = replacements;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void forEach(BiConsumer<? super String, ? super BlockPos> action) {
        this.markers.forEach(action);
    }

    public void forEachReplacement(BiConsumer<? super BlockPos, ? super BlockState> action) {
        this.replacements.forEach(action);
    }

    @Nullable
    public BlockPos lookupAny(String key) {
        Iterator<BlockPos> iterator = this.lookup(key).iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public Collection<BlockPos> lookup(String key) {
        return this.markers.get((Object)key);
    }

    public static class Builder {
        private final ImmutableMultimap.Builder<String, BlockPos> markers = ImmutableMultimap.builder();
        private final ImmutableMap.Builder<BlockPos, BlockState> replacements = ImmutableMap.builder();

        private Builder() {
        }

        public Builder add(BlockPos pos, String value) {
            String[] tokens = value.split("=", 2);
            String key = tokens[0];
            this.markers.put((Object)key, (Object)pos);
            if (tokens.length > 1) {
                String replacementString = tokens[1];
                Block replacementBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(replacementString));
                if (replacementBlock != null) {
                    this.replacements.put((Object)pos, (Object)replacementBlock.func_176223_P());
                } else {
                    Midnight.LOGGER.error("Invalid replacement marker '{}'", (Object)replacementString);
                }
            }
            return this;
        }

        public TemplateMarkers build() {
            return new TemplateMarkers((Multimap)this.markers.build(), (Map)this.replacements.build());
        }
    }
}

