/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.client.models;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import thelm.jaopca.api.blocks.IMaterialFormBlock;
import thelm.jaopca.api.blocks.IMaterialFormBlockItem;
import thelm.jaopca.api.fluids.IMaterialFormBucketItem;
import thelm.jaopca.api.fluids.IMaterialFormFluidBlock;
import thelm.jaopca.api.items.IMaterialFormItem;
import thelm.jaopca.blocks.BlockFormType;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.items.ItemFormType;

public class ModelHandler {
    private static final Multimap<ResourceLocation, ResourceLocation> REMAPS = LinkedHashMultimap.create();

    public static void registerModels() {
        ModelResourceLocation defaultModelLocation;
        ModelResourceLocation modelLocation;
        ResourceLocation location;
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        for (IMaterialFormBlock materialFormBlock : BlockFormType.getBlocks()) {
            Block block = materialFormBlock.asBlock();
            location = block.getRegistryName();
            if (resourceManager.func_219533_b(location = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json"))) continue;
            block.func_176194_O().func_177619_a().forEach(state -> {
                String propertyMapString = BlockModelShapes.func_209552_a((Map)state.func_206871_b());
                ModelResourceLocation modelLocation = new ModelResourceLocation(block.getRegistryName(), propertyMapString);
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormBlock.getMaterial().getModelType() + '/' + materialFormBlock.getForm().getName(), propertyMapString);
                ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
                REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
            });
        }
        for (IMaterialFormBlockItem materialFormBlockItem : BlockFormType.getBlockItems()) {
            BlockItem blockItem = materialFormBlockItem.asBlockItem();
            location = blockItem.getRegistryName();
            if (resourceManager.func_219533_b(location = new ResourceLocation(location.func_110624_b(), "item/models/" + location.func_110623_a() + ".json"))) continue;
            modelLocation = new ModelResourceLocation(blockItem.getRegistryName(), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormBlockItem.getMaterial().getModelType() + '/' + materialFormBlockItem.getForm().getName(), "inventory");
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
        for (IMaterialFormItem materialFormItem : ItemFormType.getItems()) {
            Item item = materialFormItem.asItem();
            location = item.getRegistryName();
            if (resourceManager.func_219533_b(location = new ResourceLocation(location.func_110624_b(), "item/models/" + location.func_110623_a() + ".json"))) continue;
            modelLocation = new ModelResourceLocation(item.getRegistryName(), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormItem.getMaterial().getModelType() + '/' + materialFormItem.getForm().getName(), "inventory");
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
        for (IMaterialFormFluidBlock materialFormFluidBlock : FluidFormType.getFluidBlocks()) {
            Block fluidBlock = materialFormFluidBlock.asBlock();
            location = fluidBlock.getRegistryName();
            if (resourceManager.func_219533_b(location = new ResourceLocation(location.func_110624_b(), "blockstates/" + location.func_110623_a() + ".json"))) continue;
            fluidBlock.func_176194_O().func_177619_a().forEach(state -> {
                String propertyMapString = BlockModelShapes.func_209552_a((Map)state.func_206871_b());
                ModelResourceLocation modelLocation = new ModelResourceLocation(fluidBlock.getRegistryName(), propertyMapString);
                ModelResourceLocation defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormFluidBlock.getMaterial().getModelType() + '/' + materialFormFluidBlock.getForm().getName(), propertyMapString);
                ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
                REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
            });
        }
        for (IMaterialFormBucketItem materialFormBucketItem : FluidFormType.getBucketItems()) {
            Item bucketItem = materialFormBucketItem.asItem();
            location = bucketItem.getRegistryName();
            if (resourceManager.func_219533_b(location = new ResourceLocation(location.func_110624_b(), "item/models/" + location.func_110623_a() + ".json"))) continue;
            modelLocation = new ModelResourceLocation(bucketItem.getRegistryName(), "inventory");
            defaultModelLocation = new ModelResourceLocation("jaopca:" + materialFormBucketItem.getMaterial().getModelType() + '/' + materialFormBucketItem.getForm().getName(), "inventory");
            ModelLoader.addSpecialModel((ResourceLocation)defaultModelLocation);
            REMAPS.put((Object)defaultModelLocation, (Object)modelLocation);
        }
    }

    public static void remapModels(ModelBakeEvent event) {
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        Map modelRegistry = event.getModelRegistry();
        IBakedModel missingModel = (IBakedModel)modelRegistry.get(ModelLoader.field_177604_a);
        for (Map.Entry entry : REMAPS.asMap().entrySet()) {
            IBakedModel defaultModel = modelRegistry.getOrDefault(entry.getKey(), missingModel);
            for (ResourceLocation modelLocation : (Collection)entry.getValue()) {
                modelRegistry.put(modelLocation, defaultModel);
            }
        }
    }
}

