/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.create.recipes;

import com.google.common.base.Strings;
import com.simibubi.create.content.contraptions.components.crusher.CrushingRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingIngredient;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSupplier
implements Supplier<CrushingRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object[] output;
    public final int time;

    public CrushingRecipeSupplier(ResourceLocation key, Object input, int time, Object ... output) {
        this(key, "", input, time, output);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, int time, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.time = time;
    }

    @Override
    public CrushingRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<ProcessingOutput> results = new ArrayList<ProcessingOutput>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            results.add(new ProcessingOutput(stack, chance.floatValue()));
        }
        return new CrushingRecipe(this.key, this.group, Collections.singletonList(new ProcessingIngredient(ing)), results, this.time);
    }
}

