/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.resources.IInMemoryResourcePack;
import thelm.jaopca.data.DataCollector;

public class MekanismDataInjector {
    public static final Set<ResourceLocation> GAS_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    public static final Set<ResourceLocation> INFUSE_TYPE_TAG_BLACKLIST = new TreeSet<ResourceLocation>();
    private static final ListMultimap<ResourceLocation, Supplier<? extends Gas>> GAS_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();
    private static final ListMultimap<ResourceLocation, Supplier<? extends InfuseType>> INFUSE_TYPE_TAGS_INJECT = MultimapBuilder.treeKeys().arrayListValues().build();

    private MekanismDataInjector() {
    }

    public static boolean registerGasTag(ResourceLocation location, Supplier<? extends Gas> gasSupplier) {
        if (GAS_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(gasSupplier);
        return GAS_TAGS_INJECT.put((Object)location, gasSupplier);
    }

    public static boolean registerInfuseTypeTag(ResourceLocation location, Supplier<? extends InfuseType> infuseTypeSupplier) {
        if (INFUSE_TYPE_TAG_BLACKLIST.contains(location)) {
            return false;
        }
        Objects.requireNonNull(location);
        Objects.requireNonNull(infuseTypeSupplier);
        return INFUSE_TYPE_TAGS_INJECT.put((Object)location, infuseTypeSupplier);
    }

    public static Set<ResourceLocation> getInjectGasTags() {
        return GAS_TAGS_INJECT.keySet();
    }

    static void setupConfig(IDynamicSpecConfig config) {
        config.setComment("gasTags", "Configurations related to gas tags.");
        GAS_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("gasTags.blacklist", new ArrayList<String>(), "List of gas tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("gases").addAll(Lists.transform(config.getDefinedStringList("gasTags.customDefined", new ArrayList<String>(), "List of gas tags that should be considered as defined."), ResourceLocation::new));
        config.setComment("infuseTypeTags", "Configurations related to infuse type tags.");
        INFUSE_TYPE_TAG_BLACKLIST.addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.blacklist", new ArrayList<String>(), "List of infuse type tags that should not be added."), ResourceLocation::new));
        DataCollector.getDefinedTags("fluids").addAll(Lists.transform(config.getDefinedStringList("infuseTypeTags.customDefined", new ArrayList<String>(), "List of infuse type tags that should be considered as defined."), ResourceLocation::new));
    }

    static void putJsons(IInMemoryResourcePack pack) {
        GAS_TAGS_INJECT.asMap().forEach((location, suppliers) -> {
            Object[] gases = (Gas[])suppliers.stream().map(Supplier::get).distinct().filter(Objects::nonNull).toArray(Gas[]::new);
            Tag tag = Tag.Builder.func_200047_a().func_200573_a(gases).func_200051_a(location);
            pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/gases/" + location.func_110623_a() + ".json"), (JsonElement)tag.func_200571_a(arg_0 -> ((IForgeRegistry)MekanismAPI.GAS_REGISTRY).getKey(arg_0)));
        });
        INFUSE_TYPE_TAGS_INJECT.asMap().forEach((location, suppliers) -> {
            Object[] entityTypes = (InfuseType[])suppliers.stream().map(Supplier::get).distinct().filter(Objects::nonNull).toArray(InfuseType[]::new);
            Tag tag = Tag.Builder.func_200047_a().func_200573_a(entityTypes).func_200051_a(location);
            pack.putJson(ResourcePackType.SERVER_DATA, new ResourceLocation(location.func_110624_b(), "tags/entity_types/" + location.func_110623_a() + ".json"), (JsonElement)tag.func_200571_a(arg_0 -> ((IForgeRegistry)MekanismAPI.INFUSE_TYPE_REGISTRY).getKey(arg_0)));
        });
    }
}

