/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.recipes;

import java.util.Objects;
import java.util.function.Supplier;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.common.recipe.impl.FluidGasToGasIRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.mekanism.MekanismHelper;

public class WashingRecipeSupplier
implements Supplier<FluidGasToGasIRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object fluidInput;
    public final int fluidInputCount;
    public final Object gasInput;
    public final int gasInputCount;
    public final Object output;
    public final int outputCount;

    public WashingRecipeSupplier(ResourceLocation key, Object fluidInput, int fluidInputCount, Object gasInput, int gasInputCount, Object output, int outputCount) {
        this.key = Objects.requireNonNull(key);
        this.fluidInput = fluidInput;
        this.fluidInputCount = fluidInputCount;
        this.gasInput = gasInput;
        this.gasInputCount = gasInputCount;
        this.output = output;
        this.outputCount = outputCount;
    }

    @Override
    public FluidGasToGasIRecipe get() {
        GasStackIngredient gasIng = MekanismHelper.INSTANCE.getGasStackIngredient(this.gasInput, this.gasInputCount);
        FluidStackIngredient fluidIng = MekanismHelper.INSTANCE.getFluidStackIngredient(this.fluidInput, this.fluidInputCount);
        GasStack stack = MekanismHelper.INSTANCE.getGasStack(this.output, this.outputCount);
        if (stack.isEmpty()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        return new FluidGasToGasIRecipe(this.key, fluidIng, gasIng, stack);
    }
}

