/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import cofh.thermal.expansion.util.recipes.machine.PulverizerRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.MiscHelper;

public class PulverizerRecipeSupplier
implements Supplier<PulverizerRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object[] output;
    public final int energy;
    public final float experience;
    public final int minTime;

    public PulverizerRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object[] output, int energy, float experience, int minTime) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.energy = energy;
        this.experience = experience;
        this.minTime = minTime;
    }

    @Override
    public PulverizerRecipe get() {
        Ingredient ing = ThermalExpansionHelper.INSTANCE.getCountedIngredient(this.input, this.inputCount);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Float> chances = new ArrayList<Float>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(-1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            outputs.add(stack);
            chances.add(chance);
        }
        return new PulverizerRecipe(this.key, this.energy, this.experience, this.minTime, Collections.singletonList(ing), Collections.emptyList(), outputs, chances, Collections.emptyList());
    }
}

