/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion.recipes;

import cofh.thermal.expansion.util.recipes.machine.SmelterRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.MiscHelper;

public class SmelterRecipeSupplier
implements Supplier<SmelterRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object[] input;
    public final Object[] output;
    public final int energy;
    public final float experience;
    public final int minTime;

    public SmelterRecipeSupplier(ResourceLocation key, Object[] input, Object[] output, int energy, float experience, int minTime) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.energy = energy;
        this.experience = experience;
        this.minTime = minTime;
    }

    @Override
    public SmelterRecipe get() {
        ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
        int i = 0;
        while (i < this.input.length) {
            Ingredient ing;
            Object in = this.input[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            if ((ing = ThermalExpansionHelper.INSTANCE.getCountedIngredient(in, count)).func_203189_d()) {
                LOGGER.warn("Empty ingredient in recipe {}: {}", (Object)this.key, in);
            }
            inputs.add(ing);
        }
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        ArrayList<Float> chances = new ArrayList<Float>();
        i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(-1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            outputs.add(stack);
            chances.add(chance);
        }
        return new SmelterRecipe(this.key, this.energy, this.experience, this.minTime, inputs, Collections.emptyList(), outputs, chances, Collections.emptyList());
    }
}

