/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.uselessmod.recipes;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;
import tk.themcbros.uselessmod.recipes.CrusherRecipe;

public class CrushingRecipeSupplier
implements Supplier<CrusherRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int count;
    public final Object secondOutput;
    public final int secondCount;
    public final float secondChance;
    public final float experience;
    public final int time;

    public CrushingRecipeSupplier(ResourceLocation key, Object input, Object output, int count, float experience, int time) {
        this(key, "", input, output, count, ItemStack.field_190927_a, 0, 0.0f, experience, time);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, Object output, int count, float experience, int time) {
        this(key, group, input, output, count, ItemStack.field_190927_a, 0, 0.0f, experience, time);
    }

    public CrushingRecipeSupplier(ResourceLocation key, Object input, Object output, int count, Object secondOutput, int secondCount, float secondChance, float experience, int time) {
        this(key, "", input, output, count, secondOutput, secondCount, secondChance, experience, time);
    }

    public CrushingRecipeSupplier(ResourceLocation key, String group, Object input, Object output, int count, Object secondOutput, int secondCount, float secondChance, float experience, int time) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.count = count;
        this.secondOutput = secondOutput;
        this.secondCount = secondCount;
        this.secondChance = secondChance;
        this.experience = experience;
        this.time = time;
    }

    @Override
    public CrusherRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondCount);
        if (this.secondChance > 0.0f && secondStack.func_190926_b()) {
            LOGGER.warn("Empty non-zero chance second output in recipe {}: {}", (Object)this.key, this.secondOutput);
        }
        return new CrusherRecipe(this.key, this.group, ing, stack, secondStack, this.secondChance, this.experience, this.time);
    }
}

