/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.wtbwmachines;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.wtbwmachines.WTBWMachinesHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"wtbw_machines"})
public class WTBWMachinesCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("charcoal", "coal", "diamond", "emerald", "gold", "iron", "quartz"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("gold", "iron"));
    private static final TreeMap<IMaterial, Object> ORE_BASES = new TreeMap();
    private Map<IMaterial, IDynamicSpecConfig> configs;

    @Override
    public String getName() {
        return "wtbw_machines_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineMaterialConfig(IModuleData moduleData, Map<IMaterial, IDynamicSpecConfig> configs) {
        this.configs = configs;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        WTBWMachinesHelper helper = WTBWMachinesHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            if (!ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) && !TO_DUST_BLACKLIST.contains(material.getName())) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerCrushingRecipe(new ResourceLocation("jaopca", "wtbw_machines.material_to_dust." + material.getName()), materialLocation, 1, 180, 2500, dustLocation, 1);
                }
            }
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) || TO_PLATE_BLACKLIST.contains(material.getName())) continue;
            materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(plateLocation)) continue;
            helper.registerCompressingRecipe(new ResourceLocation("jaopca", "wtbw_machines.material_to_plate." + material.getName()), materialLocation, 1, plateLocation, 1, 180, 2500);
        }
    }
}

