/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.registries;

import com.google.common.collect.ArrayListMultimap;
import java.util.Objects;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegistryHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ArrayListMultimap<Class<?>, IForgeRegistryEntry<?>> REGISTRY_ENTRIES = ArrayListMultimap.create();

    private RegistryHandler() {
    }

    public static void registerForgeRegistryEntry(IForgeRegistryEntry<?> entry) {
        Objects.requireNonNull(entry);
        REGISTRY_ENTRIES.put((Object)entry.getRegistryType(), entry);
    }

    public static void onRegister(RegistryEvent.Register<?> event) {
        IForgeRegistry registry = event.getRegistry();
        Class type = registry.getRegistrySuperType();
        if (REGISTRY_ENTRIES.containsKey((Object)type)) {
            for (IForgeRegistryEntry entry : REGISTRY_ENTRIES.get((Object)type)) {
                registry.register(entry);
                LOGGER.debug("Registered {} to registry {}", (Object)entry.getRegistryName(), (Object)registry.getRegistryName());
            }
            REGISTRY_ENTRIES.removeAll((Object)type);
        }
    }
}

