/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.utils;

import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import thelm.jaopca.api.fluids.IFluidProvider;
import thelm.jaopca.api.helpers.IMiscHelper;
import thelm.jaopca.config.ConfigHandler;
import thelm.jaopca.materials.MaterialHandler;
import thelm.jaopca.modules.ModuleHandler;

public class MiscHelper
implements IMiscHelper {
    public static final MiscHelper INSTANCE = new MiscHelper();
    private final ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "JAOPCA Executor Thread"));
    private static final Predicate<String> CONFIG_MATERIAL_PREDICATE = s -> "*".equals(s) || MaterialHandler.containsMaterial(s);
    private static final Predicate<String> CONFIG_MODULE_PREDICATE = s -> "*".equals(s) || ModuleHandler.getModuleMap().containsKey(s);

    private MiscHelper() {
    }

    @Override
    public ResourceLocation createResourceLocation(String location, String defaultNamespace) {
        if (StringUtils.contains((CharSequence)location, (int)58)) {
            return new ResourceLocation(location);
        }
        return new ResourceLocation(defaultNamespace, location);
    }

    @Override
    public ResourceLocation createResourceLocation(String location) {
        return this.createResourceLocation(location, "forge");
    }

    @Override
    public ResourceLocation getTagLocation(String form, String material) {
        return this.createResourceLocation(form + (StringUtils.isEmpty((CharSequence)material) ? "" : '/' + material));
    }

    @Override
    public ItemStack getItemStack(Object obj, int count) {
        if (obj instanceof Supplier) {
            return this.getItemStack(((Supplier)obj).get(), count);
        }
        if (obj instanceof ItemStack) {
            return (ItemStack)obj;
        }
        if (obj instanceof IItemProvider) {
            return new ItemStack((IItemProvider)obj, count);
        }
        if (obj instanceof String) {
            return this.getPreferredItemStack(this.makeItemWrapperTag(new ResourceLocation((String)obj)).func_199885_a(), count);
        }
        if (obj instanceof ResourceLocation) {
            return this.getPreferredItemStack(this.makeItemWrapperTag((ResourceLocation)obj).func_199885_a(), count);
        }
        if (obj instanceof Tag) {
            return this.getPreferredItemStack(((Tag)obj).func_199885_a(), count);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Ingredient getIngredient(Object obj) {
        if (obj instanceof Supplier) {
            return this.getIngredient(((Supplier)obj).get());
        }
        if (obj instanceof Ingredient) {
            return (Ingredient)obj;
        }
        if (obj instanceof String) {
            return Ingredient.func_199805_a(this.makeItemWrapperTag(new ResourceLocation((String)obj)));
        }
        if (obj instanceof ResourceLocation) {
            return Ingredient.func_199805_a(this.makeItemWrapperTag((ResourceLocation)obj));
        }
        if (obj instanceof Tag) {
            return Ingredient.func_199805_a((Tag)((Tag)obj));
        }
        if (obj instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)obj});
        }
        if (obj instanceof ItemStack[]) {
            return Ingredient.func_193369_a((ItemStack[])((ItemStack[])obj));
        }
        if (obj instanceof IItemProvider) {
            return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)obj});
        }
        if (obj instanceof IItemProvider[]) {
            return Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])obj));
        }
        if (obj instanceof Ingredient.IItemList) {
            return Ingredient.func_209357_a(Stream.of((Ingredient.IItemList)obj));
        }
        if (obj instanceof Ingredient.IItemList[]) {
            return Ingredient.func_209357_a(Stream.of((Ingredient.IItemList[])obj));
        }
        if (obj instanceof JsonElement) {
            return Ingredient.func_199802_a((JsonElement)((JsonElement)obj));
        }
        return Ingredient.field_193370_a;
    }

    public Tag<Item> makeItemWrapperTag(ResourceLocation location) {
        return new ItemTags.Wrapper(location);
    }

    public ItemStack getPreferredItemStack(Collection<Item> collection, int count) {
        return new ItemStack((IItemProvider)this.getPreferredEntry(collection).orElse(Items.field_190931_a), count);
    }

    public FluidStack getFluidStack(Object obj, int amount) {
        if (obj instanceof Supplier) {
            return this.getFluidStack(((Supplier)obj).get(), amount);
        }
        if (obj instanceof FluidStack) {
            return (FluidStack)obj;
        }
        if (obj instanceof Fluid) {
            return new FluidStack((Fluid)obj, amount);
        }
        if (obj instanceof IFluidProvider) {
            return new FluidStack(((IFluidProvider)obj).asFluid(), amount);
        }
        if (obj instanceof String) {
            return this.getPreferredFluidStack(this.makeFluidWrapperTag(new ResourceLocation((String)obj)).func_199885_a(), amount);
        }
        if (obj instanceof ResourceLocation) {
            return this.getPreferredFluidStack(this.makeFluidWrapperTag((ResourceLocation)obj).func_199885_a(), amount);
        }
        if (obj instanceof Tag) {
            return this.getPreferredFluidStack(((Tag)obj).func_199885_a(), amount);
        }
        return FluidStack.EMPTY;
    }

    public Tag<Fluid> makeFluidWrapperTag(ResourceLocation location) {
        return new FluidTags.Wrapper(location);
    }

    public FluidStack getPreferredFluidStack(Collection<Fluid> collection, int amount) {
        return new FluidStack(this.getPreferredEntry(collection).orElse(Fluids.field_204541_a), amount);
    }

    @Override
    public <T extends IForgeRegistryEntry<T>> Optional<T> getPreferredEntry(Collection<T> list) {
        IForgeRegistryEntry preferredEntry = null;
        int currBest = ConfigHandler.PREFERRED_MODS.size();
        for (IForgeRegistryEntry entry : list) {
            ResourceLocation rl = entry.getRegistryName();
            if (rl == null) continue;
            String modId = rl.func_110624_b();
            int idx = ConfigHandler.PREFERRED_MODS.indexOf(modId);
            if (preferredEntry != null && (idx < 0 || idx >= currBest)) continue;
            preferredEntry = entry;
            currBest = idx;
        }
        return Optional.ofNullable(preferredEntry);
    }

    @Override
    public void caclulateMaterialSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = TreeMultiset.create(configList);
        int listCount = list.count((Object)"*");
        MaterialHandler.getMaterialMap().keySet().forEach(s -> list.add(s, listCount));
        list.remove((Object)"*", listCount);
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public void caclulateModuleSet(Collection<String> configList, Collection<String> actualSet) {
        TreeMultiset list = TreeMultiset.create(configList);
        int listCount = list.count((Object)"*");
        ModuleHandler.getModuleMap().keySet().forEach(s -> list.add(s, listCount));
        list.remove((Object)"*", listCount);
        actualSet.clear();
        list.entrySet().stream().filter(e -> (e.getCount() & 1) == 1).map(Multiset.Entry::getElement).forEach(actualSet::add);
    }

    @Override
    public Predicate<String> configMaterialPredicate() {
        return CONFIG_MATERIAL_PREDICATE;
    }

    @Override
    public Predicate<String> configModulePredicate() {
        return CONFIG_MODULE_PREDICATE;
    }

    public <T> Future<T> submitAsyncTask(Callable<T> task) {
        return this.executor.submit(task);
    }

    public Future<?> submitAsyncTask(Runnable task) {
        return this.executor.submit(task);
    }

    public int squareColorDifference(int color1, int color2) {
        int diffR = (color1 << 16 & 0xFF) - (color2 << 16 & 0xFF);
        int diffG = (color1 << 8 & 0xFF) - (color2 << 8 & 0xFF);
        int diffB = (color1 & 0xFF) - (color2 & 0xFF);
        return diffR * diffR + diffG * diffG + diffB * diffB;
    }
}

