/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import info.u_team.u_team_core.util.MathUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.registries.GameData;

public class LocateStructureSubCommand {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.uteamcore.locatestructure.failed", new Object[0]));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"locatestructure").requires(source -> source.func_197034_c(2))).then(Commands.func_197056_a((String)"structure", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests((context, builder) -> ISuggestionProvider.func_197013_a(GameData.getStructureFeatures().func_148742_b().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder)).executes(context -> LocateStructureSubCommand.locateStructure((CommandSource)context.getSource(), (ResourceLocation)context.getArgument("structure", ResourceLocation.class))));
    }

    private static int locateStructure(CommandSource source, ResourceLocation structureName) throws CommandSyntaxException {
        BlockPos pos = new BlockPos(source.func_197036_d());
        BlockPos foundPos = source.func_197023_e().func_211157_a(structureName.func_110623_a(), pos, 100, false);
        if (foundPos == null) {
            throw FAILED_EXCEPTION.create();
        }
        int distance = MathHelper.func_76141_d((float)MathUtil.getPlaneDistance(pos.func_177958_n(), pos.func_177952_p(), foundPos.func_177958_n(), foundPos.func_177952_p()));
        ITextComponent text = TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{foundPos.func_177958_n(), "~", foundPos.func_177952_p()})).func_211710_a(style -> style.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + foundPos.func_177958_n() + " ~ " + foundPos.func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.uteamcore.locatestructure.success", new Object[]{structureName, text, distance}), false);
        return distance;
    }
}

