/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.annotation;

import info.u_team.u_team_core.api.construct.Construct;
import info.u_team.u_team_core.api.construct.IModConstruct;
import info.u_team.u_team_core.api.integration.IModIntegration;
import info.u_team.u_team_core.api.integration.Integration;
import info.u_team.u_team_core.util.annotation.AnnotationUtil;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.objectweb.asm.Type;

public class AnnotationManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"AnnotationManager");
    private static final Marker CONSTRUCT_MARKER = MarkerManager.getMarker((String)"Construct");
    private static final Marker INTEGRATION_MARKER = MarkerManager.getMarker((String)"Integration");

    public static void callAnnotations(String modid) {
        AnnotationManager.callConstructs(modid);
        AnnotationManager.callIntegrations(modid);
    }

    public static void callConstructs(String modid) {
        for (ModFileScanData.AnnotationData data : AnnotationUtil.getAnnotations(modid, Type.getType(Construct.class))) {
            if (!AnnotationManager.canBeCalled(modid, data)) continue;
            LOGGER.debug(CONSTRUCT_MARKER, "Load construct (" + data.getMemberName() + ") for mod " + modid);
            try {
                Class.forName(data.getMemberName()).asSubclass(IModConstruct.class).newInstance().construct();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError ex) {
                LOGGER.error(CONSTRUCT_MARKER, "Failed to load and call mod construct : {}", (Object)data.getMemberName(), (Object)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    public static void callIntegrations(String modid) {
        for (ModFileScanData.AnnotationData data : AnnotationUtil.getAnnotations(modid, Type.getType(Integration.class))) {
            String integrationModid = (String)data.getAnnotationData().get("integration");
            if (!AnnotationManager.canBeCalled(modid, data) || !ModList.get().isLoaded(integrationModid)) continue;
            LOGGER.debug(INTEGRATION_MARKER, "Load " + integrationModid + " integration (" + data.getMemberName() + ") for mod " + modid);
            try {
                Class.forName(data.getMemberName()).asSubclass(IModIntegration.class).newInstance().construct();
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | LinkageError ex) {
                LOGGER.error(INTEGRATION_MARKER, "Failed to load and call integration : {}", (Object)data.getMemberName(), (Object)ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private static boolean canBeCalled(String modid, ModFileScanData.AnnotationData data) {
        String annotationModid = (String)data.getAnnotationData().get("modid");
        Boolean client = (Boolean)data.getAnnotationData().get("client");
        return modid.equals(annotationModid) && (client == null || client == false || client != false && FMLEnvironment.dist == Dist.CLIENT);
    }
}

