/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.world;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraft.world.storage.WorldSavedData;

public class WorldUtil {
    public static RayTraceResult rayTraceServerSide(Entity entity, double range) {
        return WorldUtil.rayTraceServerSide(entity, range, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE);
    }

    public static RayTraceResult rayTraceServerSide(Entity entity, double range, RayTraceContext.BlockMode blockMode, RayTraceContext.FluidMode fluidMode) {
        Vec3d playerVector = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        Vec3d lookVector = entity.func_70040_Z();
        Vec3d locationVector = playerVector.func_72441_c(lookVector.field_72450_a * range, lookVector.field_72448_b * range, lookVector.field_72449_c * range);
        return entity.field_70170_p.func_217299_a(new RayTraceContext(playerVector, locationVector, blockMode, fluidMode, entity));
    }

    public static <T extends WorldSavedData> T getSaveData(ServerWorld world, String name, Function<String, T> defaultData) {
        return (T)WorldUtil.getSaveData(world, name, () -> (WorldSavedData)defaultData.apply(name));
    }

    public static <T extends WorldSavedData> T getSaveData(ServerWorld world, String name, Supplier<T> defaultData) {
        return (T)world.func_217481_x().func_215752_a(defaultData, name);
    }

    public static ServerWorld getServerWorld(Entity entity, DimensionType type) {
        return WorldUtil.getServerWorld(entity.func_184102_h(), type);
    }

    public static ServerWorld getServerWorld(MinecraftServer server, DimensionType type) {
        return server.func_71218_a(type);
    }

    public static void teleportEntity(Entity entity, DimensionType type, BlockPos pos) {
        WorldUtil.teleportEntity(entity, type, new Vec3d((Vec3i)pos));
    }

    public static void teleportEntity(Entity entity, DimensionType type, Vec3d pos) {
        WorldUtil.teleportEntity(entity, WorldUtil.getServerWorld(entity, type), pos);
    }

    public static void teleportEntity(Entity entity, ServerWorld world, BlockPos pos) {
        WorldUtil.teleportEntity(entity, world, new Vec3d((Vec3i)pos));
    }

    public static void teleportEntity(Entity entity, ServerWorld world, Vec3d pos) {
        WorldUtil.teleportEntity(entity, world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), entity.field_70177_z, entity.field_70125_A);
    }

    public static void teleportEntity(Entity entity, DimensionType type, double x, double y, double z, float yaw, float pitch) {
        WorldUtil.teleportEntity(entity, WorldUtil.getServerWorld(entity, type), x, y, z, yaw, pitch);
    }

    public static void teleportEntity(Entity entity, ServerWorld world, double x, double y, double z, float yaw, float pitch) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            world.func_72863_F().func_217228_a(TicketType.field_223185_g, new ChunkPos(new BlockPos(x, y, z)), 1, (Object)entity.func_145782_y());
            if (world == entity.field_70170_p) {
                player.field_71135_a.func_147364_a(x, y, z, yaw, pitch);
            } else {
                player.func_200619_a(world, x, y, z, yaw, pitch);
            }
            entity.func_70034_d(yaw);
        } else {
            float wrapedYaw = MathHelper.func_76142_g((float)yaw);
            float wrapedPitch = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)pitch), (float)-90.0f, (float)90.0f);
            if (world == entity.field_70170_p) {
                entity.func_70012_b(x, y, z, wrapedYaw, wrapedPitch);
                entity.func_70034_d(wrapedYaw);
            } else {
                entity.field_71093_bK = world.field_73011_w.func_186058_p();
                Entity entityCopy = entity;
                if ((entity = entity.func_200600_R().func_200721_a((World)world)) == null) {
                    return;
                }
                entity.func_180432_n(entityCopy);
                entityCopy.remove(false);
                entity.func_70012_b(x, y, z, wrapedYaw, wrapedPitch);
                entity.func_70034_d(wrapedYaw);
                world.func_217460_e(entity);
            }
        }
    }
}

