/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.utils;

import com.girafi.waddles.utils.BiomeDictionaryHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigurationHandler {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final General GENERAL = new General(BUILDER);
    public static final Spawn SPAWN = new Spawn(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();

    public static class Spawn {
        public final ForgeConfigSpec.IntValue min;
        public final ForgeConfigSpec.IntValue max;
        public final ForgeConfigSpec.IntValue weight;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> include;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> exclude;

        Spawn(ForgeConfigSpec.Builder builder) {
            builder.push("spawn chances");
            builder.comment("Configure penguins spawn weight & min/max group size. Set weight to 0 to disable.");
            this.min = builder.defineInRange("min", 1, 0, 64);
            this.max = builder.defineInRange("max", 4, 0, 64);
            this.weight = builder.defineInRange("weight", 4, 0, 100);
            builder.pop();
            builder.push("spawnable biomes");
            builder.comment("BiomeDictionary types to include & exclude.");
            this.include = builder.defineList("include", Collections.singletonList(BiomeDictionary.Type.SNOWY.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            this.exclude = builder.defineList("exclude", Arrays.asList(BiomeDictionary.Type.FOREST.toString(), BiomeDictionary.Type.MOUNTAIN.toString(), BiomeDictionary.Type.NETHER.toString()), o -> BiomeDictionary.Type.getAll().contains(BiomeDictionaryHelper.getType(String.valueOf(o))));
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.BooleanValue dropFish;
        public final ForgeConfigSpec.BooleanValue dropExp;

        General(ForgeConfigSpec.Builder builder) {
            builder.push("general");
            this.dropFish = builder.comment("Enable that penguins drop fish (0 - 2 Raw Cod)").translation("waddles.configgui.dropFish").define("dropFish", false);
            this.dropExp = builder.comment("Penguins should drop experience?").translation("waddles.configgui.dropExp").define("dropExp", true);
            builder.pop();
        }
    }
}

