/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.transport.conveyor;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.block.transport.tile.ConveyorTile;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.module.ModuleTransport;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.utils.IndustrialTags;
import com.google.common.collect.Sets;
import com.hrznstudio.titanium.recipe.generator.TitaniumShapedRecipeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;

public class ConveyorExtractionUpgrade
extends ConveyorUpgrade {
    public static VoxelShape NORTHBB = VoxelShapes.func_197873_a((double)0.25, (double)0.1875, (double)-0.125, (double)0.75, (double)0.6875, (double)0.1875);
    public static VoxelShape SOUTHBB = VoxelShapes.func_197873_a((double)0.25, (double)0.1875, (double)0.8125, (double)0.75, (double)0.6875, (double)1.125);
    public static VoxelShape EASTBB = VoxelShapes.func_197873_a((double)0.8125, (double)0.1875, (double)0.25, (double)1.125, (double)0.6875, (double)0.75);
    public static VoxelShape WESTBB = VoxelShapes.func_197873_a((double)-0.125, (double)0.1875, (double)0.25, (double)0.1875, (double)0.6875, (double)0.75);
    private boolean fast = false;
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private List<ItemEntity> items = new ArrayList<ItemEntity>();

    public ConveyorExtractionUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, Direction side) {
        super(container, factory, side);
    }

    @Override
    public VoxelShape getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74757_a("fast", this.fast);
        compound.func_218657_a("Filter", (INBT)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.fast = nbt.func_74767_n("fast");
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
    }

    @Override
    public boolean onUpgradeActivated(PlayerEntity player, Hand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() == Items.field_151114_aO && !this.fast) {
            this.fast = true;
            held.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        if (!this.fast) {
            return super.getDrops();
        }
        return Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((IItemProvider)this.getFactory().getUpgradeItem(), 1), new ItemStack((IItemProvider)Items.field_151114_aO)});
    }

    @Override
    public void update() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.items.removeIf(ItemEntity2 -> ItemEntity2.func_92059_d().func_190926_b() || !ItemEntity2.func_70089_S());
        if (this.items.size() >= 20) {
            return;
        }
        if (this.getWorld().func_82737_E() % (long)(this.fast ? 10 : 20) == 0L) {
            this.getHandlerCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack stack = itemHandler.extractItem(i, 4, true);
                    if (stack.func_190926_b() || this.whitelist != this.filter.matches(stack)) continue;
                    ItemEntity item = new ItemEntity(this.getWorld(), (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.2, (double)this.getPos().func_177952_p() + 0.5);
                    item.func_213293_j(0.0, -1.0, 0.0);
                    item.func_174867_a(40);
                    item.func_92058_a(itemHandler.extractItem(i, 4, false));
                    if (!this.getWorld().func_217376_c((Entity)item)) break;
                    this.items.add(item);
                    break;
                }
            });
        }
        if (this.getContainer() instanceof ConveyorTile) {
            FluidTank tank = ((ConveyorTile)this.getContainer()).getTank();
            this.getHandlerCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(arg_0 -> this.lambda$update$2((IFluidTank)tank, arg_0));
        }
    }

    private <T> LazyOptional<T> getHandlerCapability(Capability<T> capability) {
        BlockPos offsetPos = this.getPos().func_177972_a(this.getSide());
        TileEntity tile = this.getWorld().func_175625_s(offsetPos);
        if (tile != null && tile.getCapability(capability, this.getSide().func_176734_d()).isPresent()) {
            return tile.getCapability(capability, this.getSide().func_176734_d());
        }
        Iterator iterator = this.getWorld().func_217357_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(offsetPos)).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            if (!entity.getCapability(capability, (entity = (Entity)iterator.next()) instanceof ServerPlayerEntity ? null : this.getSide().func_176734_d()).isPresent()) continue;
            return entity.getCapability(capability, entity instanceof ServerPlayerEntity ? null : this.getSide().func_176734_d());
        }
        return LazyOptional.empty();
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, CompoundNBT compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, ItemStack.func_199557_a((CompoundNBT)compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorExtractionUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorExtractionUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    private /* synthetic */ void lambda$update$2(IFluidTank tank, IFluidHandler fluidHandler) {
        FluidStack drain;
        if (!fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE).isEmpty() && this.whitelist == this.filter.matches(fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE)) && (drain = fluidHandler.drain(tank.fill(fluidHandler.drain(250, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE)).isEmpty() && drain.getAmount() > 0) {
            this.getContainer().requestFluidSync();
        }
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("extraction");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, Direction face) {
            return new ConveyorExtractionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(Direction upgradeSide, Direction conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_extractor_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_extraction_upgrade");
        }

        public void registerRecipe(Consumer<IFinishedRecipe> consumer) {
            TitaniumShapedRecipeBuilder.shapedRecipe((IItemProvider)this.getUpgradeItem()).func_200472_a("IPI").func_200472_a("IDI").func_200472_a("ICI").func_200469_a(Character.valueOf('I'), Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('P'), IndustrialTags.Items.PLASTIC).func_200462_a(Character.valueOf('D'), (IItemProvider)Blocks.field_150367_z).func_200462_a(Character.valueOf('C'), (IItemProvider)ModuleTransport.CONVEYOR).func_200464_a(consumer);
        }
    }
}

