/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.item.infinity;

import com.buuz135.industrial.item.infinity.InfinityEnergyStorage;
import com.buuz135.industrial.item.infinity.InfinityStackHolder;
import com.buuz135.industrial.item.infinity.InfinityTier;
import com.buuz135.industrial.item.infinity.ItemInfinity;
import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.capability.IStackHolder;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.capability.CapabilityItemStackHolder;
import com.hrznstudio.titanium.capability.FluidHandlerScreenProviderItemStack;
import com.hrznstudio.titanium.capability.ItemStackHolderCapability;
import com.hrznstudio.titanium.client.screen.addon.TankScreenAddon;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class InfinityCapabilityProvider
implements ICapabilityProvider {
    private final FluidHandlerScreenProviderItemStack tank;
    private final InfinityEnergyStorage energyStorage;
    private final ItemStackHolderCapability itemStackHolder;
    private final LazyOptional<IEnergyStorage> energyStorageCap;
    private final LazyOptional<IFluidHandlerItem> tankCap;
    private final LazyOptional<IStackHolder> stackCap;

    public InfinityCapabilityProvider(final ItemStack stack) {
        this.tank = new FluidHandlerScreenProviderItemStack(stack, 1000000){

            public boolean canFillFluidType(FluidStack fluid) {
                return fluid != null && fluid.getFluid() != null && fluid.getFluid().equals(ModuleCore.BIOFUEL.getSourceFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return false;
            }

            @Nonnull
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new TankScreenAddon(30, 20, (IFluidTank)InfinityCapabilityProvider.this.tank, FluidTankComponent.Type.NORMAL));
            }
        };
        this.energyStorage = new InfinityEnergyStorage(){

            @Override
            public long getLongEnergyStored() {
                if (stack.func_77942_o()) {
                    return Math.min(stack.func_77978_p().func_74763_f("Energy"), InfinityTier.ARTIFACT.getPowerNeeded());
                }
                return 0L;
            }

            @Override
            public void setEnergyStored(long energy) {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new CompoundNBT());
                }
                stack.func_77978_p().func_74772_a("Energy", Math.min(energy, InfinityTier.ARTIFACT.getPowerNeeded()));
            }

            @Override
            public boolean canReceive() {
                return ItemInfinity.canCharge(stack);
            }
        };
        this.itemStackHolder = new InfinityStackHolder();
        this.tankCap = LazyOptional.of(() -> this.tank);
        this.energyStorageCap = LazyOptional.of(() -> this.energyStorage);
        this.stackCap = LazyOptional.of(() -> this.itemStackHolder);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return this.tankCap.cast();
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return this.energyStorageCap.cast();
        }
        if (capability == CapabilityItemStackHolder.ITEMSTACK_HOLDER_CAPABILITY) {
            return this.stackCap.cast();
        }
        return LazyOptional.empty();
    }
}

