/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.registry;

import com.legacy.conjurer_illager.ConjurerIllagerMod;
import com.legacy.conjurer_illager.IllagerRegistry;
import com.legacy.conjurer_illager.entity.BouncingBallEntity;
import com.legacy.conjurer_illager.entity.ConjurerEntity;
import com.legacy.conjurer_illager.entity.ThrowingCardEntity;
import com.legacy.conjurer_illager.util.EnumHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="conjurer_illager")
public class IllagerEntityTypes {
    public static final EntityType<ConjurerEntity> CONJURER = IllagerEntityTypes.buildEntity("conjurer", EntityType.Builder.func_220322_a(ConjurerEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.95f));
    public static final EntityType<BouncingBallEntity> BOUNCING_BALL = IllagerEntityTypes.buildEntity("bouncing_ball", EntityType.Builder.func_220322_a(BouncingBallEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(BouncingBallEntity::new).func_220320_c().setShouldReceiveVelocityUpdates(true).func_220321_a(0.4f, 0.4f));
    public static final EntityType<ThrowingCardEntity> THROWING_CARD = IllagerEntityTypes.buildEntity("throwing_card", EntityType.Builder.func_220322_a(ThrowingCardEntity::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory(ThrowingCardEntity::new).func_220320_c().setShouldReceiveVelocityUpdates(true).func_220321_a(0.3f, 0.1f));

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        IllagerRegistry.register(event.getRegistry(), "conjurer", CONJURER);
        IllagerRegistry.register(event.getRegistry(), "bouncing_ball", BOUNCING_BALL);
        IllagerRegistry.register(event.getRegistry(), "throwing_card", THROWING_CARD);
        IllagerEntityTypes.registerSpawnConditions();
        IllagerEntityTypes.addParticle("bouncy_balls", 73, 243.0, 162.0, 43.0);
        IllagerEntityTypes.addParticle("rabbit", 74, 255.0, 208.0, 208.0);
        IllagerEntityTypes.addParticle("displace", 75, 165.0, 96.0, 201.0);
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(ConjurerIllagerMod.find(key));
    }

    private static void registerSpawnConditions() {
        EntitySpawnPlacementRegistry.func_209343_a(CONJURER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MobEntity::func_223315_a);
    }

    public static void addParticle(String name, int id, double red, double green, double blue) {
        double r = red / 255.0;
        double g = green / 255.0;
        double b = blue / 255.0;
        EnumHelper.addEnum(SpellcastingIllagerEntity.SpellType.class, name.toUpperCase(), new Class[]{Integer.TYPE, Double.TYPE, Double.TYPE, Double.TYPE}, id, r, g, b);
    }
}

