/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.conjurer_illager.util;

import com.google.common.collect.Lists;
import com.legacy.conjurer_illager.ConjurerIllagerMod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import org.apache.commons.lang3.ArrayUtils;

public class EnumHelper {
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;

    private static void setup() {
        if (isSetup) {
            return;
        }
        try {
            Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
            reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
            newConstructorAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newConstructorAccessor", Constructor.class);
            newInstance = Class.forName("sun.reflect.ConstructorAccessor").getDeclaredMethod("newInstance", Object[].class);
            newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
            fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
        }
        catch (Exception e) {
            ConjurerIllagerMod.LOGGER.error("Error setting up EnumHelper.", (Throwable)e);
        }
        isSetup = true;
    }

    private static Object getConstructorAccessor(Class<?> enumClass, Class<?>[] additionalParameterTypes) throws Exception {
        Class[] parameterTypes = new Class[additionalParameterTypes.length + 2];
        parameterTypes[0] = String.class;
        parameterTypes[1] = Integer.TYPE;
        System.arraycopy(additionalParameterTypes, 0, parameterTypes, 2, additionalParameterTypes.length);
        return newConstructorAccessor.invoke(reflectionFactory, enumClass.getDeclaredConstructor(parameterTypes));
    }

    private static <T extends Enum<?>> T makeEnum(Class<T> enumClass, @Nullable String value, int ordinal, Class<?>[] additionalTypes, @Nullable Object[] additionalValues) throws Exception {
        int additionalParamsCount = additionalValues == null ? 0 : additionalValues.length;
        Object[] params = new Object[additionalParamsCount + 2];
        params[0] = value;
        params[1] = ordinal;
        if (additionalValues != null) {
            System.arraycopy(additionalValues, 0, params, 2, additionalValues.length);
        }
        return (T)((Enum)enumClass.cast(newInstance.invoke(EnumHelper.getConstructorAccessor(enumClass, additionalTypes), new Object[]{params})));
    }

    public static void setFailsafeFieldValue(Field field, @Nullable Object target, @Nullable Object value) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, field, false);
        fieldAccessorSet.invoke(fieldAccessor, target, value);
    }

    private static void blankField(Class<?> enumClass, String fieldName) throws Exception {
        for (Field field : Class.class.getDeclaredFields()) {
            if (!field.getName().contains(fieldName)) continue;
            field.setAccessible(true);
            EnumHelper.setFailsafeFieldValue(field, enumClass, null);
            break;
        }
    }

    private static void cleanEnumCache(Class<?> enumClass) throws Exception {
        EnumHelper.blankField(enumClass, "enumConstantDirectory");
        EnumHelper.blankField(enumClass, "enumConstants");
    }

    @Nullable
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return EnumHelper.addEnum(false, enumType, enumName, paramTypes, paramValues);
    }

    @Nullable
    private static <T extends Enum<?>> T addEnum(boolean test, final Class<T> enumType, @Nullable String enumName, final Class<?>[] paramTypes, @Nullable Object[] paramValues) {
        Field[] fields;
        if (!isSetup) {
            EnumHelper.setup();
        }
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = 4122;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            final ArrayList lines = Lists.newArrayList();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Runtime Deobf: %s", false));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            for (String line : lines) {
                ConjurerIllagerMod.LOGGER.fatal(line);
            }
            if (test) {
                throw new EnhancedRuntimeException("Could not find $VALUES field for enum: " + enumType.getName()){

                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        for (String line : lines) {
                            stream.println(line);
                        }
                    }
                };
            }
            return null;
        }
        if (test) {
            Object ctr = null;
            Exception ex = null;
            try {
                ctr = EnumHelper.getConstructorAccessor(enumType, paramTypes);
            }
            catch (Exception e) {
                ex = e;
            }
            if (ctr == null || ex != null) {
                throw new EnhancedRuntimeException(String.format("Could not find constructor for Enum %s", enumType.getName()), ex){

                    private String toString(Class<?>[] cls) {
                        StringBuilder b = new StringBuilder();
                        for (int x = 0; x < cls.length; ++x) {
                            b.append(cls[x].getName());
                            if (x == cls.length - 1) continue;
                            b.append(", ");
                        }
                        return b.toString();
                    }

                    protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                        stream.println("Target Arguments:");
                        stream.println("java.lang.String, int, " + this.toString(paramTypes));
                        stream.println("Found Constructors:");
                        for (Constructor<?> ctr : enumType.getDeclaredConstructors()) {
                            stream.println("    " + this.toString(ctr.getParameterTypes()));
                        }
                    }
                };
            }
            return null;
        }
        valuesField.setAccessible(true);
        try {
            Object[] previousValues = (Enum[])valuesField.get(enumType);
            T newValue = EnumHelper.makeEnum(enumType, enumName, previousValues.length, paramTypes, paramValues);
            EnumHelper.setFailsafeFieldValue(valuesField, null, ArrayUtils.add((Object[])previousValues, newValue));
            EnumHelper.cleanEnumCache(enumType);
            return newValue;
        }
        catch (Exception e) {
            ConjurerIllagerMod.LOGGER.error("Error adding enum with EnumHelper.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        if (!isSetup) {
            EnumHelper.setup();
        }
    }
}

