/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.craftinggrid;

import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsstorage.craftinggrid.CraftingGridProvider;
import mcjty.rftoolsstorage.craftinggrid.CraftingRecipe;
import mcjty.rftoolsstorage.craftinggrid.IItemKey;
import mcjty.rftoolsstorage.craftinggrid.IItemSource;
import mcjty.rftoolsstorage.craftinggrid.PacketCraftTestResultToClient;
import mcjty.rftoolsstorage.craftinggrid.PacketGridToClient;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.setup.RFToolsStorageMessages;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCraftingTools {
    @Nonnull
    private static int[] tryRecipe(PlayerEntity player, CraftingRecipe craftingRecipe, int n, IItemSource itemSource, boolean strictDamage) {
        CraftingInventory workInventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity var1) {
                return false;
            }
        }, 3, 3);
        CraftingInventory inventory = craftingRecipe.getInventory();
        int[] missingCount = new int[10];
        IntSet[] hashSets = new IntSet[9];
        for (int i = 0; i < 10; ++i) {
            if (i < 9) {
                ItemStack stack = inventory.func_70301_a(i);
                missingCount[i] = !stack.func_190926_b() ? stack.func_190916_E() * n : 0;
                workInventory.func_70299_a(i, ItemStack.field_190927_a);
                continue;
            }
            missingCount[i] = 0;
        }
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            int size = input.func_190916_E();
            if (input.func_190926_b()) continue;
            for (int i = 0; i < 9; ++i) {
                ItemStack stack;
                if (missingCount[i] <= 0 || !StorageCraftingTools.match(stack = inventory.func_70301_a(i), hashSets[i], input, strictDamage)) continue;
                if (size > missingCount[i]) {
                    size -= missingCount[i];
                    missingCount[i] = 0;
                } else {
                    int n2 = i;
                    missingCount[n2] = missingCount[n2] - size;
                    size = 0;
                }
                workInventory.func_70299_a(i, input.func_77946_l());
            }
        }
        Optional<ICraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        missingCount[9] = recipe.map(r -> r.func_77569_a((IInventory)workInventory, player.func_130014_f_()) ? 0 : 1).orElse(0);
        if (missingCount[9] == 0) {
            for (int i = 0; i < 9; ++i) {
                if (missingCount[i] <= 0) continue;
                missingCount[9] = 1;
                break;
            }
        }
        return missingCount;
    }

    private static List<ItemStack> testAndConsumeCraftingItems(PlayerEntity player, CraftingRecipe craftingRecipe, IItemSource itemSource, boolean strictDamage) {
        CraftingInventory workInventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity var1) {
                return false;
            }
        }, 3, 3);
        ArrayList<Pair<IItemKey, ItemStack>> undo = new ArrayList<Pair<IItemKey, ItemStack>>();
        ArrayList result = new ArrayList();
        CraftingInventory inventory = craftingRecipe.getInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (!stack.func_190926_b()) {
                int count = stack.func_190916_E();
                if ((count = StorageCraftingTools.findMatchingItems(workInventory, undo, i, stack, count, itemSource, strictDamage)) <= 0) continue;
                StorageCraftingTools.undo(player, itemSource, undo);
                return Collections.emptyList();
            }
            workInventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        Optional<ICraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        return recipe.map(r -> {
            if (!r.func_77569_a((IInventory)workInventory, player.func_130014_f_())) {
                result.clear();
                StorageCraftingTools.undo(player, itemSource, undo);
                return result;
            }
            ItemStack stack = r.func_77572_b((IInventory)workInventory);
            if (!stack.func_190926_b()) {
                result.add(stack);
                NonNullList remaining = r.func_179532_b((IInventory)workInventory);
                for (ItemStack s : remaining) {
                    if (s.func_190926_b()) continue;
                    result.add(s);
                }
            } else {
                result.clear();
                StorageCraftingTools.undo(player, itemSource, undo);
            }
            return result;
        }).orElse(result);
    }

    private static boolean match(@Nonnull ItemStack target, @Nonnull IntSet targetIDs, @Nonnull ItemStack input, boolean strictDamage) {
        if (strictDamage) {
            return target.func_77973_b() == input.func_77973_b() && target.func_77952_i() == input.func_77952_i();
        }
        if (target.func_77973_b() == input.func_77973_b()) {
            return true;
        }
        if (targetIDs.isEmpty()) {
            return false;
        }
        return false;
    }

    private static int findMatchingItems(CraftingInventory workInventory, List<Pair<IItemKey, ItemStack>> undo, int i, @Nonnull ItemStack stack, int count, IItemSource itemSource, boolean strictDamage) {
        IntSets.EmptySet stackIDs = IntSets.EMPTY_SET;
        for (Pair<IItemKey, ItemStack> pair : itemSource.getItems()) {
            ItemStack input = (ItemStack)pair.getValue();
            if (!input.func_190926_b() && StorageCraftingTools.match(stack, (IntSet)stackIDs, input, strictDamage)) {
                workInventory.func_70299_a(i, input.func_77946_l());
                int ss = count;
                if (input.func_190916_E() - ss < 0) {
                    ss = input.func_190916_E();
                }
                count -= ss;
                IItemKey key = (IItemKey)pair.getKey();
                ItemStack actuallyExtracted = itemSource.decrStackSize(key, ss);
                undo.add((Pair<IItemKey, ItemStack>)Pair.of((Object)key, (Object)actuallyExtracted));
            }
            if (count != 0) continue;
            break;
        }
        return count;
    }

    private static void undo(PlayerEntity player, IItemSource itemSource, List<Pair<IItemKey, ItemStack>> undo) {
        for (Pair<IItemKey, ItemStack> pair : undo) {
            int amountLeft;
            ItemStack stack = (ItemStack)pair.getValue();
            if (itemSource.insertStack((IItemKey)pair.getKey(), stack) || (amountLeft = itemSource.insertStackAnySlot((IItemKey)pair.getKey(), stack)) <= 0) continue;
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(amountLeft);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)copy);
        }
        player.field_71070_bA.func_75142_b();
    }

    public static void craftItems(PlayerEntity player, int nn, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        Optional<ICraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (!recipe.isPresent()) {
            return;
        }
        int[] n = new int[]{nn};
        recipe.ifPresent(r -> {
            ItemStack recipeResult = r.func_77571_b();
            if (!recipeResult.func_190926_b() && recipeResult.func_190916_E() > 0) {
                if (n[0] == -1) {
                    n[0] = recipeResult.func_77976_d();
                }
                int remainder = n[0] % recipeResult.func_190916_E();
                n[0] = n[0] / recipeResult.func_190916_E();
                if (remainder != 0) {
                    n[0] = n[0] + 1;
                }
                if (n[0] * recipeResult.func_190916_E() > recipeResult.func_77976_d()) {
                    n[0] = n[0] - 1;
                }
                for (int i = 0; i < n[0]; ++i) {
                    List<ItemStack> result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, true);
                    if (result.isEmpty() && (result = StorageCraftingTools.testAndConsumeCraftingItems(player, craftingRecipe, itemSource, false)).isEmpty()) {
                        return;
                    }
                    for (ItemStack stack : result) {
                        if (player.field_71071_by.func_70441_a(stack)) continue;
                        player.func_70099_a(stack, 1.05f);
                    }
                }
            }
        });
    }

    @Nonnull
    public static int[] testCraftItems(PlayerEntity player, int nn, CraftingRecipe craftingRecipe, IItemSource itemSource) {
        Optional<ICraftingRecipe> recipe = craftingRecipe.getCachedRecipe(player.func_130014_f_());
        if (!recipe.isPresent()) {
            return new int[0];
        }
        int[] n = new int[]{nn};
        return recipe.map(r -> {
            ItemStack recipeResult = r.func_77571_b();
            if (!recipeResult.func_190926_b() && recipeResult.func_190916_E() > 0) {
                if (n[0] == -1) {
                    n[0] = recipeResult.func_77976_d();
                }
                int remainder = n[0] % recipeResult.func_190916_E();
                n[0] = n[0] / recipeResult.func_190916_E();
                if (remainder != 0) {
                    n[0] = n[0] + 1;
                }
                if (n[0] * recipeResult.func_190916_E() > recipeResult.func_77976_d()) {
                    n[0] = n[0] - 1;
                }
                int[] result = StorageCraftingTools.tryRecipe(player, craftingRecipe, n[0], itemSource, true);
                for (int i = 0; i < 10; ++i) {
                    if (result[i] <= 0) continue;
                    int[] result2 = StorageCraftingTools.tryRecipe(player, craftingRecipe, n[0], itemSource, false);
                    if (result2[9] == 0) {
                        return result2;
                    }
                    return result;
                }
                return result;
            }
            return new int[0];
        }).orElse(new int[0]);
    }

    public static void craftFromGrid(PlayerEntity player, int count, boolean test, BlockPos pos, DimensionId type) {
        int[] testResult = new int[]{};
        TileEntity te = WorldTools.getWorld((World)player.func_130014_f_(), (DimensionId)type).func_175625_s(pos);
        if (te instanceof CraftingGridProvider) {
            testResult = ((CraftingGridProvider)te).craft(player, count, test);
        }
        if (testResult.length > 0) {
            RFToolsStorageMessages.INSTANCE.sendTo((Object)new PacketCraftTestResultToClient(testResult), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    public static void requestGridSync(PlayerEntity player, BlockPos pos, DimensionId type) {
        ServerWorld world = WorldTools.getWorld((World)player.func_130014_f_(), (DimensionId)type);
        CraftingGridProvider provider = null;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof CraftingGridProvider && te instanceof GenericTileEntity) {
            provider = (CraftingGridProvider)te;
        }
        boolean dummy = false;
        if (te instanceof StorageScannerTileEntity) {
            dummy = ((StorageScannerTileEntity)te).isDummy();
        }
        if (provider != null) {
            RFToolsStorageMessages.INSTANCE.sendTo((Object)new PacketGridToClient(dummy ? null : pos, ((GenericTileEntity)te).getDimensionType(), provider.getCraftingGrid()), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }
}

