/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.craftingmanager.blocks;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolsbase.modules.crafting.items.CraftingCardItem;
import mcjty.rftoolsstorage.modules.craftingmanager.CraftingManagerModule;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerContainer;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingQueue;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingRequest;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingSystem;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingManagerTileEntity
extends GenericTileEntity {
    public static final ModelProperty<BlockState>[] MIMIC = new ModelProperty[]{new ModelProperty(), new ModelProperty(), new ModelProperty(), new ModelProperty()};
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> this.items);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Modular Storage").containerSupplier((windowId, player) -> new CraftingManagerContainer((int)windowId, this.func_174877_v(), (PlayerEntity)player, this)).itemHandler(() -> (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).map(h -> h).orElseThrow(RuntimeException::new)));
    private final CraftingQueue[] queues = new CraftingQueue[4];
    private boolean devicesDirty = true;
    public static final double QUALITY_NOTPOSSIBLE = -1.0;
    public static final double QUALITY_DEVICEIDLE = 10000.0;

    public CraftingManagerTileEntity() {
        super((TileEntityType)CraftingManagerModule.TYPE_CRAFTING_MANAGER.get());
        for (int i = 0; i < 4; ++i) {
            this.queues[i] = new CraftingQueue();
        }
    }

    private Optional<ICraftingDevice> getDevice(int queueIndex) {
        if (this.devicesDirty) {
            this.updateDevices();
        }
        return Optional.ofNullable(this.queues[queueIndex].getDevice());
    }

    public boolean tick(CraftingSystem system) {
        boolean rc = false;
        for (int queueIndex = 0; queueIndex < 4; ++queueIndex) {
            int finalQueueIndex = queueIndex;
            rc = this.getDevice(queueIndex).map(device -> {
                device.tick();
                if (device.getStatus() == ICraftingDevice.Status.READY) {
                    this.sendResultsBack(finalQueueIndex, system);
                    return true;
                }
                return false;
            }).orElse(rc);
        }
        return rc;
    }

    private void sendResultsBack(int queueIndex, CraftingSystem system) {
        List output = this.getDevice(queueIndex).map(ICraftingDevice::extractOutput).orElse(Collections.emptyList());
        StorageScannerTileEntity storage = system.getStorage();
        for (ItemStack stack : output) {
            ItemStack left = storage.insertInternal(stack, false);
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((double)storage.func_174877_v().func_177958_n() + 0.5), (double)((double)storage.func_174877_v().func_177956_o() + 1.5), (double)((double)storage.func_174877_v().func_177952_p() + 0.5), (ItemStack)left);
        }
    }

    public boolean canCraft(Ingredient ingredient) {
        for (int i = 4; i < this.items.getSlots(); ++i) {
            ItemStack result;
            ItemStack card = this.items.getStackInSlot(i);
            if (card.func_190926_b() || !ingredient.test(result = CraftingCardItem.getResult((ItemStack)card))) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getCraftables() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 4; i < this.items.getSlots(); ++i) {
            ItemStack result;
            ItemStack card = this.items.getStackInSlot(i);
            if (card.func_190926_b() || (result = CraftingCardItem.getResult((ItemStack)card)).func_190926_b()) continue;
            stacks.add(result);
        }
        return stacks;
    }

    public Pair<Double, Integer> getCraftingQuality(Ingredient ingredient, int amount) {
        AtomicDouble bestQuality = new AtomicDouble(-1.0);
        AtomicInteger bestDevice = new AtomicInteger(-1);
        for (int queueIndex = 0; queueIndex < 4; ++queueIndex) {
            int finalQueueIndex = queueIndex;
            this.getDevice(queueIndex).ifPresent(device -> {
                Queue<CraftingRequest> requests = this.queues[finalQueueIndex].getRequests();
                double baseQuality = Math.max(0.0, 1.0 - (double)requests.size() / 10.0);
                switch (device.getStatus()) {
                    case IDLE: {
                        baseQuality += 10000.0;
                        break;
                    }
                    case READY: {
                        baseQuality += 0.5;
                        break;
                    }
                }
                double quality = -1.0;
                for (int i = this.getFirstCardIndex(finalQueueIndex); i < this.getLastCardIndex(finalQueueIndex); ++i) {
                    ItemStack result;
                    ItemStack card = this.items.getStackInSlot(i);
                    if (card.func_190926_b() || !ingredient.test(result = CraftingCardItem.getResult((ItemStack)card))) continue;
                    quality = baseQuality;
                    break;
                }
                if (quality >= 0.0 && quality > bestQuality.get()) {
                    bestQuality.set(quality);
                    bestDevice.set(finalQueueIndex);
                }
            });
        }
        return Pair.of((Object)bestQuality.get(), (Object)bestDevice.get());
    }

    private int getLastCardIndex(int queueIndex) {
        return 4 + queueIndex * 8 + 8;
    }

    private int getFirstCardIndex(int queueIndex) {
        return 4 + queueIndex * 8;
    }

    public CraftingQueue[] getQueues() {
        return this.queues;
    }

    @Nonnull
    public List<Ingredient> getIngredients(int queueIndex, CraftingRequest request) {
        CraftingQueue queue = this.queues[queueIndex];
        if (this.devicesDirty) {
            this.updateDevices();
        }
        for (int i = this.getFirstCardIndex(queueIndex); i < this.getLastCardIndex(queueIndex); ++i) {
            ItemStack cardStack = this.items.getStackInSlot(i);
            if (cardStack.func_190926_b()) continue;
            ItemStack cardResult = CraftingCardItem.getResult((ItemStack)cardStack);
            if (!request.getIngredient().test(cardResult)) continue;
            queue.getDevice().setupCraft(this.field_145850_b, cardStack);
            return queue.getDevice().getIngredients();
        }
        return Collections.emptyList();
    }

    public boolean startCraft(int queueIndex, CraftingRequest request, List<ItemStack> ingredients) {
        CraftingQueue queue = this.queues[queueIndex];
        if (this.devicesDirty) {
            this.updateDevices();
        }
        return queue.getDevice().insertIngredients(this.field_145850_b, ingredients);
    }

    private void updateDevices() {
        for (int i = 0; i < 4; ++i) {
            ItemStack deviceStack = this.items.getStackInSlot(i);
            ResourceLocation id = deviceStack.func_77973_b().getRegistryName();
            ResourceLocation deviceId = CraftingManagerModule.CRAFTING_DEVICE_REGISTRY.getDeviceForBlock(id);
            if (deviceId == null) continue;
            Supplier<ICraftingDevice> device = CraftingManagerModule.CRAFTING_DEVICE_REGISTRY.getDeviceSupplier(deviceId);
            ICraftingDevice craftingDevice = device.get();
            this.queues[i].setDevice(craftingDevice);
        }
        this.devicesDirty = false;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        ItemStack origMimic0 = this.items.getStackInSlot(0);
        ItemStack origMimic1 = this.items.getStackInSlot(1);
        ItemStack origMimic2 = this.items.getStackInSlot(2);
        ItemStack origMimic3 = this.items.getStackInSlot(3);
        this.readClientDataFromNBT(pkt.func_148857_g());
        ItemStack mimic0 = this.items.getStackInSlot(0);
        ItemStack mimic1 = this.items.getStackInSlot(1);
        ItemStack mimic2 = this.items.getStackInSlot(2);
        ItemStack mimic3 = this.items.getStackInSlot(3);
        if (!(ItemStack.func_179545_c((ItemStack)origMimic0, (ItemStack)mimic0) && ItemStack.func_179545_c((ItemStack)origMimic1, (ItemStack)mimic1) && ItemStack.func_179545_c((ItemStack)origMimic2, (ItemStack)mimic2) && ItemStack.func_179545_c((ItemStack)origMimic3, (ItemStack)mimic3))) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 3);
        }
    }

    @Nonnull
    public IModelData getModelData() {
        BlockState mimic0 = this.items.getStackInSlot(0).func_190926_b() ? null : ((BlockItem)this.items.getStackInSlot(0).func_77973_b()).func_179223_d().func_176223_P();
        BlockState mimic1 = this.items.getStackInSlot(1).func_190926_b() ? null : ((BlockItem)this.items.getStackInSlot(1).func_77973_b()).func_179223_d().func_176223_P();
        BlockState mimic2 = this.items.getStackInSlot(2).func_190926_b() ? null : ((BlockItem)this.items.getStackInSlot(2).func_77973_b()).func_179223_d().func_176223_P();
        BlockState mimic3 = this.items.getStackInSlot(3).func_190926_b() ? null : ((BlockItem)this.items.getStackInSlot(3).func_77973_b()).func_179223_d().func_176223_P();
        return new ModelDataMap.Builder().withInitial(MIMIC[0], (Object)mimic0).withInitial(MIMIC[1], (Object)mimic1).withInitial(MIMIC[2], (Object)mimic2).withInitial(MIMIC[3], (Object)mimic3).build();
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        ListNBT deviceList = tagCompound.func_150295_c("devices", 10);
        int i = 0;
        for (INBT nbt : deviceList) {
            CompoundNBT deviceNBT = (CompoundNBT)nbt;
            if (!deviceNBT.isEmpty()) {
                ResourceLocation deviceId = new ResourceLocation(deviceNBT.func_74779_i("deviceId"));
                Supplier<ICraftingDevice> deviceSupplier = CraftingManagerModule.CRAFTING_DEVICE_REGISTRY.getDeviceSupplier(deviceId);
                ICraftingDevice device = deviceSupplier.get();
                this.queues[i].setDevice(device);
                device.read(deviceNBT);
            }
            ++i;
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        ListNBT deviceList = new ListNBT();
        for (int i = 0; i < this.queues.length; ++i) {
            CompoundNBT deviceNBT = new CompoundNBT();
            if (this.queues[i].hasDevice()) {
                this.queues[i].getDevice().write(deviceNBT);
                deviceNBT.func_74778_a("deviceId", this.queues[i].getDevice().getID().toString());
            }
            deviceList.add((Object)deviceNBT);
        }
        tagCompound.func_218657_a("devices", (INBT)deviceList);
        return tagCompound;
    }

    @Nonnull
    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)CraftingManagerContainer.CONTAINER_FACTORY.get()){

            protected void onUpdate(int index) {
                if (index < 4) {
                    CraftingManagerTileEntity.this.markDirtyClient();
                    CraftingManagerTileEntity.this.devicesDirty = true;
                }
                super.onUpdate(index);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

