/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.api.infoscreen.IInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.blocks.DefaultPowerInformationScreenInfo;
import mcjty.rftoolsbase.modules.informationscreen.client.DefaultPowerInformationRenderer;
import mcjty.rftoolsstorage.modules.craftingmanager.blocks.CraftingManagerTileEntity;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingQueue;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingRequest;
import mcjty.rftoolsstorage.modules.craftingmanager.system.CraftingSystem;
import mcjty.rftoolsstorage.modules.craftingmanager.system.ICraftingDevice;
import mcjty.rftoolsstorage.modules.scanner.blocks.StorageScannerTileEntity;
import mcjty.rftoolsstorage.modules.scanner.client.StorageScannerInformationRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.tuple.Pair;

public class StorageScannerInformationScreenInfo
implements IInformationScreenInfo {
    public static final int MODE_CRAFTING = 2;
    public static final Key<ItemStack> CRAFT1 = new Key("craft1", Type.ITEMSTACK);
    public static final Key<ItemStack> CRAFT2 = new Key("craft2", Type.ITEMSTACK);
    public static final Key<ItemStack> CRAFT3 = new Key("craft3", Type.ITEMSTACK);
    public static final Key<ItemStack> CRAFT4 = new Key("craft4", Type.ITEMSTACK);
    public static final Key<ItemStack> CRAFT5 = new Key("craft5", Type.ITEMSTACK);
    public static final Key<ItemStack> CRAFT6 = new Key("craft6", Type.ITEMSTACK);
    public static final Key<String> CRAFT1_ERROR = new Key("craft1error", Type.STRING);
    public static final Key<String> CRAFT2_ERROR = new Key("craft2error", Type.STRING);
    public static final Key<String> CRAFT3_ERROR = new Key("craft3error", Type.STRING);
    public static final Key<String> CRAFT4_ERROR = new Key("craft4error", Type.STRING);
    public static final Key<String> CRAFT5_ERROR = new Key("craft5error", Type.STRING);
    public static final Key<String> CRAFT6_ERROR = new Key("craft6error", Type.STRING);
    public static final Pair<Key<ItemStack>, Key<String>>[] CRAFT_KEYS = new Pair[]{Pair.of(CRAFT1, CRAFT1_ERROR), Pair.of(CRAFT2, CRAFT2_ERROR), Pair.of(CRAFT3, CRAFT3_ERROR), Pair.of(CRAFT4, CRAFT4_ERROR), Pair.of(CRAFT5, CRAFT5_ERROR), Pair.of(CRAFT6, CRAFT6_ERROR)};
    private final StorageScannerTileEntity scanner;

    public StorageScannerInformationScreenInfo(StorageScannerTileEntity scanner) {
        this.scanner = scanner;
    }

    public int[] getSupportedModes() {
        return new int[]{0, 1, 2};
    }

    public void tick() {
    }

    @Nonnull
    public TypedMap getInfo(int mode) {
        if (mode == 0 || mode == 1) {
            return (TypedMap)this.scanner.getCapability(CapabilityEnergy.ENERGY).map(h -> TypedMap.builder().put(DefaultPowerInformationScreenInfo.ENERGY, (Object)h.getEnergyStored()).put(DefaultPowerInformationScreenInfo.MAXENERGY, (Object)h.getMaxEnergyStored()).build()).orElse((Object)TypedMap.EMPTY);
        }
        TypedMap.Builder builder = TypedMap.builder();
        int idx = 0;
        CraftingSystem craftingSystem = this.scanner.getCraftingSystem();
        World world = this.scanner.func_145831_w();
        for (BlockPos pos : this.scanner.getCraftingInventories()) {
            if (idx >= CRAFT_KEYS.length) break;
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof CraftingManagerTileEntity)) continue;
            CraftingManagerTileEntity craftingManager = (CraftingManagerTileEntity)te;
            for (CraftingQueue queue : craftingManager.getQueues()) {
                ICraftingDevice device = queue.getDevice();
                if (device == null || device.getStatus() != ICraftingDevice.Status.BUSY) continue;
                StorageScannerInformationScreenInfo.add(builder, idx++, device.getCraftingItem(), null);
            }
        }
        List<CraftingRequest> failedRequests = craftingSystem.getFailedRequests();
        for (CraftingRequest request : failedRequests) {
            if (idx >= CRAFT_KEYS.length) break;
            ItemStack[] stacks = request.getIngredient().func_193365_a();
            if (stacks.length <= 0) continue;
            StorageScannerInformationScreenInfo.add(builder, idx++, stacks[0], "Missing");
        }
        return builder.build();
    }

    private static void add(TypedMap.Builder builder, int idx, ItemStack stack, String error) {
        builder.put((Key)CRAFT_KEYS[idx].getLeft(), (Object)stack);
        builder.put((Key)CRAFT_KEYS[idx].getRight(), (Object)error);
    }

    public void render(int mode, MatrixStack matrixStack, IRenderTypeBuffer buffer, @Nonnull TypedMap data, Direction orientation, double scale) {
        if (mode == 0) {
            DefaultPowerInformationRenderer.renderDefault((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (TypedMap)data, (Direction)orientation, (double)scale);
        } else if (mode == 1) {
            DefaultPowerInformationRenderer.renderGraphical((MatrixStack)matrixStack, (IRenderTypeBuffer)buffer, (TypedMap)data, (Direction)orientation, (double)scale);
        } else {
            StorageScannerInformationRenderer.renderCrafting(matrixStack, buffer, data, orientation, scale);
        }
    }
}

