/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.List;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.SoundTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.IScreenModuleUpdater;
import mcjty.rftoolsbase.api.screens.ITooltipInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class StorageControlScreenModule
implements IScreenModule<ModuleDataStacks>,
ITooltipInfo,
IScreenModuleUpdater {
    private ItemStackList stacks = ItemStackList.create((int)9);
    protected DimensionId dim = DimensionId.overworld();
    protected BlockPos coordinate = BlockPosTools.INVALID;
    private boolean starred = false;
    private int dirty = -1;

    public ModuleDataStacks getData(IScreenDataHelper helper, World worldObj, long millis) {
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(worldObj, this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return null;
        }
        int[] amounts = new int[this.stacks.size()];
        for (int i = 0; i < this.stacks.size(); ++i) {
            amounts[i] = scannerTileEntity.countItems((ItemStack)this.stacks.get(i), this.starred);
        }
        return new ModuleDataStacks(amounts);
    }

    public static IStorageScanner getStorageScanner(World worldObj, DimensionId dim, BlockPos coordinate) {
        ServerWorld world = WorldTools.getWorld((World)worldObj, (DimensionId)dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(coordinate);
        if (te == null) {
            return null;
        }
        if (!(te instanceof IStorageScanner)) {
            return null;
        }
        return (IStorageScanner)te;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        IStorageScanner te;
        if (tagCompound != null) {
            this.setupCoordinateFromNBT(tagCompound, dim, pos);
            for (int i = 0; i < this.stacks.size(); ++i) {
                if (!tagCompound.func_74764_b("stack" + i)) continue;
                this.stacks.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)tagCompound.func_74775_l("stack" + i)));
            }
        }
        if ((te = StorageControlScreenModule.getStorageScanner((World)WorldTools.getOverworld(), dim, this.coordinate)) != null) {
            te.clearCachedCounts();
        }
    }

    private int getHighlightedStack(int hitx, int hity) {
        int i = 0;
        for (int yy = 0; yy < 3; ++yy) {
            int y = 7 + yy * 35;
            for (int xx = 0; xx < 3; ++xx) {
                boolean hilighted;
                int x = xx * 40;
                boolean bl = hilighted = hitx >= x + 8 && hitx <= x + 38 && hity >= y - 7 && hity <= y + 22;
                if (hilighted) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public List<String> getInfo(World world, int x, int y) {
        int i;
        IStorageScanner te = StorageControlScreenModule.getStorageScanner(world, this.dim, this.coordinate);
        if (te != null && (i = this.getHighlightedStack(x, y)) != -1 && !((ItemStack)this.stacks.get(i)).func_190926_b()) {
            return Collections.singletonList(TextFormatting.GREEN + "Item: " + TextFormatting.WHITE + ((ItemStack)this.stacks.get(i)).func_200301_q());
        }
        return Collections.emptyList();
    }

    protected void setupCoordinateFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        this.coordinate = BlockPosTools.INVALID;
        this.starred = tagCompound.func_74767_n("starred");
        if (tagCompound.func_74764_b("monitorx")) {
            this.dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim")));
            BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
            int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
            int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
            int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
            this.coordinate = c;
        }
    }

    public int getRfPerTick() {
        return (Integer)StorageScannerConfiguration.STORAGE_CONTROL_RFPERTICK.get();
    }

    private boolean isShown(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (ItemStack s : this.stacks) {
            if (!StorageControlScreenModule.isItemEqual(stack, s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isItemEqual(ItemStack thisItem, ItemStack other) {
        if (other.func_190926_b()) {
            return false;
        }
        return thisItem.func_77969_a(other);
    }

    public CompoundNBT update(CompoundNBT tagCompound, World world, PlayerEntity player) {
        if (this.dirty >= 0) {
            CompoundNBT newCompound = tagCompound.func_74737_b();
            CompoundNBT tc = new CompoundNBT();
            ((ItemStack)this.stacks.get(this.dirty)).func_77955_b(tc);
            newCompound.func_218657_a("stack" + this.dirty, (INBT)tc);
            if (player != null) {
                SoundTools.playSound((World)player.func_130014_f_(), (SoundEvent)SoundEvents.field_187604_bf, (double)player.func_180425_c().func_177958_n(), (double)player.func_180425_c().func_177956_o(), (double)player.func_180425_c().func_177952_p(), (double)1.0, (double)1.0);
            }
            this.dirty = -1;
            return newCompound;
        }
        return null;
    }

    public void mouseClick(World world, int hitx, int hity, boolean clicked, PlayerEntity player) {
        if (!clicked || player == null) {
            return;
        }
        if (BlockPosTools.INVALID.equals((Object)this.coordinate)) {
            player.func_146105_b((ITextComponent)new StringTextComponent(TextFormatting.RED + "Module is not linked to storage scanner!"), false);
            return;
        }
        IStorageScanner scannerTileEntity = StorageControlScreenModule.getStorageScanner(player.field_70170_p, this.dim, this.coordinate);
        if (scannerTileEntity == null) {
            return;
        }
        if (hitx >= 0) {
            boolean insertAllActive;
            boolean insertStackActive;
            boolean bl = insertStackActive = hitx >= 0 && hitx < 60 && hity > 98;
            if (insertStackActive) {
                if (this.isShown(player.func_184586_b(Hand.MAIN_HAND))) {
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.func_184586_b(Hand.MAIN_HAND), player);
                    player.func_184611_a(Hand.MAIN_HAND, stack);
                }
                player.field_71070_bA.func_75142_b();
                return;
            }
            boolean bl2 = insertAllActive = hitx >= 60 && hity > 98;
            if (insertAllActive) {
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    if (!this.isShown(player.field_71071_by.func_70301_a(i))) continue;
                    ItemStack stack = scannerTileEntity.injectStackFromScreen(player.field_71071_by.func_70301_a(i), player);
                    player.field_71071_by.func_70299_a(i, stack);
                }
                player.field_71070_bA.func_75142_b();
                return;
            }
            int i = this.getHighlightedStack(hitx, hity);
            if (i != -1) {
                if (((ItemStack)this.stacks.get(i)).func_190926_b()) {
                    ItemStack heldItem = player.func_184614_ca();
                    if (!heldItem.func_190926_b()) {
                        ItemStack stack = heldItem.func_77946_l();
                        stack.func_190920_e(1);
                        this.stacks.set(i, (Object)stack);
                        this.dirty = i;
                    }
                } else {
                    scannerTileEntity.giveToPlayerFromScreen((ItemStack)this.stacks.get(i), player.func_225608_bj_(), player);
                }
            }
        }
    }

    public static class ModuleDataStacks
    implements IModuleData {
        public static final String ID = "rftoolsstorage:storage";
        private int[] amounts = null;

        public String getId() {
            return ID;
        }

        public ModuleDataStacks(int ... amountsIn) {
            this.amounts = amountsIn;
        }

        public ModuleDataStacks(ByteBuf buf) {
            int s = buf.readInt();
            this.amounts = new int[s];
            for (int i = 0; i < s; ++i) {
                this.amounts[i] = buf.readInt();
            }
        }

        public int getAmount(int idx) {
            return this.amounts[idx];
        }

        public void writeToBuf(PacketBuffer buf) {
            buf.writeInt(this.amounts.length);
            for (int i : this.amounts) {
                buf.writeInt(i);
            }
        }
    }
}

