/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.storage;

import java.util.Objects;
import javax.annotation.Nonnull;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.storage.IStorageListener;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import mcjty.rftoolsstorage.storage.StorageInfo;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class GlobalStorageItemWrapper
implements IItemHandlerModifiable {
    @Nonnull
    private StorageInfo info;
    private StorageEntry storage;
    private NonNullList<ItemStack> emptyHandler = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    private final boolean remote;
    private IStorageListener listener;

    public GlobalStorageItemWrapper(@Nonnull StorageInfo info, boolean remote) {
        this.info = info;
        this.remote = remote;
    }

    public void setInfo(@Nonnull StorageInfo info) {
        if (Objects.equals(info, this.info)) {
            return;
        }
        this.info = info;
        if (info.getSize() != this.emptyHandler.size()) {
            this.emptyHandler = NonNullList.func_191197_a((int)info.getSize(), (Object)ItemStack.field_190927_a);
        }
        this.storage = null;
    }

    public void setListener(IStorageListener listener) {
        this.listener = listener;
    }

    private void createStorage() {
        if (this.storage == null && this.info.getUuid() != null) {
            this.storage = this.remote ? RFToolsStorage.setup.clientStorageHolder.getStorage(this.info.getUuid(), this.info.getVersion()) : StorageHolder.get((World)WorldTools.getOverworld()).getOrCreateStorageEntry(this.info.getUuid(), this.info.getSize(), this.info.getCreatedBy());
        }
    }

    @Nonnull
    private NonNullList<ItemStack> getStacks() {
        this.createStorage();
        if (this.storage == null) {
            return this.emptyHandler;
        }
        return this.storage.getStacks();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (this.info.isEmpty()) {
            return;
        }
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return;
        }
        stacks.set(slot, (Object)stack);
        this.onContentsChanged(slot);
    }

    private void onContentsChanged(int slot) {
        if (!this.remote) {
            if (this.storage != null) {
                this.storage.updateVersion();
                if (this.listener != null) {
                    this.listener.onContentsChanged(this.storage.getVersion(), slot);
                }
            }
            StorageHolder.get((World)WorldTools.getOverworld()).save();
        }
    }

    public int getSlots() {
        return this.getStacks().size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)stacks.get(slot);
    }

    private int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (this.info.isEmpty()) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return stack;
        }
        ItemStack existing = (ItemStack)stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0 || this.info.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        NonNullList<ItemStack> stacks = this.getStacks();
        if (slot >= stacks.size()) {
            return ItemStack.field_190927_a;
        }
        ItemStack existing = (ItemStack)stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.info.isEmpty()) {
            return false;
        }
        return slot < this.info.getSize();
    }
}

