/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.paulf.fairylights.server.block.entity.FastenerBlockEntity;
import me.paulf.fairylights.server.capability.CapabilityHandler;
import me.paulf.fairylights.server.collision.Collidable;
import me.paulf.fairylights.server.collision.Intersection;
import me.paulf.fairylights.server.connection.Connection;
import me.paulf.fairylights.server.connection.HangingLightsConnection;
import me.paulf.fairylights.server.connection.PlayerAction;
import me.paulf.fairylights.server.entity.FenceFastenerEntity;
import me.paulf.fairylights.server.fastener.CollectFastenersEvent;
import me.paulf.fairylights.server.fastener.Fastener;
import me.paulf.fairylights.server.fastener.FastenerType;
import me.paulf.fairylights.server.jingle.Jingle;
import me.paulf.fairylights.util.Catenary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.INetHandler;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ClientEventHandler {
    private static final float HIGHLIGHT_ALPHA = 0.4f;

    @Nullable
    public static Connection getHitConnection() {
        Entity entity;
        RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
        if (result instanceof EntityRayTraceResult && (entity = ((EntityRayTraceResult)result).func_216348_a()) instanceof HitConnection) {
            return ((HitConnection)entity).result.connection;
        }
        return null;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END && mc.field_71441_e != null && !mc.func_147113_T()) {
            this.getBlockEntities((World)mc.field_71441_e).stream().filter(FastenerBlockEntity.class::isInstance).map(FastenerBlockEntity.class::cast).flatMap(f -> (Stream)f.getCapability(CapabilityHandler.FASTENER_CAP).map(Stream::of).orElse(Stream.empty())).forEach(Fastener::update);
        }
    }

    private Collection<TileEntity> getBlockEntities(World world) {
        try {
            return new ArrayList<TileEntity>(world.field_147482_g);
        }
        catch (ConcurrentModificationException e) {
            return Collections.emptyList();
        }
    }

    @SubscribeEvent
    public void gatherOverlayText(RenderGameOverlayEvent.Text event) {
        Connection conn = ClientEventHandler.getHitConnection();
        if (!(conn instanceof HangingLightsConnection)) {
            return;
        }
        Jingle jingle = ((HangingLightsConnection)conn).getPlayingJingle();
        if (jingle != null) {
            ArrayList lines = event.getRight();
            if (lines.size() > 0) {
                lines.add("");
            }
            lines.add("Song: " + jingle.getName());
            lines.add("Artist: " + jingle.getArtist());
        }
    }

    public static void updateHitConnection() {
        HitResult result;
        Minecraft mc = Minecraft.func_71410_x();
        Entity viewer = mc.func_175606_aa();
        if (mc.field_71476_x != null && mc.field_71441_e != null && viewer != null && (result = ClientEventHandler.getHitConnection((World)mc.field_71441_e, viewer)) != null) {
            Vec3d eyes = viewer.func_174824_e(1.0f);
            if (result.intersection.getResult().func_72438_d(eyes) < mc.field_71476_x.func_216347_e().func_72438_d(eyes)) {
                mc.field_71476_x = new EntityRayTraceResult((Entity)new HitConnection((World)mc.field_71441_e, result));
                mc.field_147125_j = null;
            }
        }
    }

    @Nullable
    private static HitResult getHitConnection(World world, Entity viewer) {
        AxisAlignedBB bounds = new AxisAlignedBB(viewer.func_180425_c()).func_186662_g(33.0);
        Set<Fastener<?>> fasteners = ClientEventHandler.collectFasteners(world, bounds);
        return ClientEventHandler.getHitConnection(viewer, bounds, fasteners);
    }

    private static Set<Fastener<?>> collectFasteners(World world, AxisAlignedBB bounds) {
        LinkedHashSet fasteners = Sets.newLinkedHashSet();
        CollectFastenersEvent event = new CollectFastenersEvent(world, bounds, fasteners);
        world.func_217357_a(FenceFastenerEntity.class, bounds).forEach(event::accept);
        int minX = MathHelper.func_76128_c((double)(bounds.field_72340_a / 16.0));
        int maxX = MathHelper.func_76143_f((double)(bounds.field_72336_d / 16.0));
        int minZ = MathHelper.func_76128_c((double)(bounds.field_72339_c / 16.0));
        int maxZ = MathHelper.func_76143_f((double)(bounds.field_72334_f / 16.0));
        AbstractChunkProvider provider = world.func_72863_F();
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                Chunk chunk = provider.func_217205_a(x, z, false);
                if (chunk == null) continue;
                event.accept(chunk);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return fasteners;
    }

    @Nullable
    private static HitResult getHitConnection(Entity viewer, AxisAlignedBB bounds, Set<Fastener<?>> fasteners) {
        if (fasteners.isEmpty()) {
            return null;
        }
        Vec3d origin = viewer.func_174824_e(1.0f);
        Vec3d look = viewer.func_70676_i(1.0f);
        double reach = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vec3d end = origin.func_72441_c(look.field_72450_a * reach, look.field_72448_b * reach, look.field_72449_c * reach);
        Connection found = null;
        Intersection rayTrace = null;
        double distance = Double.MAX_VALUE;
        for (Fastener<?> fastener : fasteners) {
            for (Connection connection : fastener.getOwnConnections()) {
                double dist;
                Collidable collision;
                Intersection result;
                if (connection.getDestination().getType() == FastenerType.PLAYER || (result = (collision = connection.getCollision()).intersect(origin, end)) == null || !((dist = result.getResult().func_72438_d(origin)) < distance)) continue;
                distance = dist;
                found = connection;
                rayTrace = result;
            }
        }
        if (found == null) {
            return null;
        }
        return new HitResult(found, rayTrace);
    }

    public static RayTraceResult drawSelectionBox(RayTraceResult target, WorldRenderer context, ActiveRenderInfo info, float delta, MatrixStack matrix) {
        if (target.func_216346_c() == RayTraceResult.Type.ENTITY) {
            MinecraftForge.EVENT_BUS.post((Event)new DrawHighlightEvent.HighlightEntity(context, info, target, delta, matrix, (IRenderTypeBuffer)Minecraft.func_71410_x().func_228019_au_().func_228487_b_()));
        }
        return target;
    }

    @SubscribeEvent
    public void drawBlockHighlight(DrawHighlightEvent.HighlightEntity event) {
        Entity entity = event.getTarget().func_216348_a();
        Vec3d pos = event.getInfo().func_216785_c();
        IRenderTypeBuffer buf = event.getBuffers();
        if (entity instanceof FenceFastenerEntity) {
            this.drawFenceFastenerHighlight((FenceFastenerEntity)entity, event.getMatrix(), buf.getBuffer(RenderType.func_228659_m_()), event.getPartialTicks(), pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        } else if (entity instanceof HitConnection) {
            HitConnection hit = (HitConnection)entity;
            if (hit.result.intersection.getFeatureType() == Connection.CORD_FEATURE) {
                MatrixStack matrix = event.getMatrix();
                matrix.func_227860_a_();
                Vec3d p = hit.result.connection.getFastener().getConnectionPoint();
                matrix.func_227861_a_(p.field_72450_a - pos.field_72450_a, p.field_72448_b - pos.field_72448_b, p.field_72449_c - pos.field_72449_c);
                this.renderHighlight(hit.result.connection, matrix, buf.getBuffer(RenderType.func_228659_m_()));
                matrix.func_227865_b_();
            } else {
                AxisAlignedBB bb = hit.result.intersection.getHitBox().func_72317_d(-pos.field_72450_a, -pos.field_72448_b, -pos.field_72449_c).func_186662_g(0.002);
                WorldRenderer.func_228430_a_((MatrixStack)event.getMatrix(), (IVertexBuilder)buf.getBuffer(RenderType.func_228659_m_()), (AxisAlignedBB)bb, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            }
        }
    }

    private void drawFenceFastenerHighlight(FenceFastenerEntity fence, MatrixStack matrix, IVertexBuilder buf, float delta, double dx, double dy, double dz) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (player.func_70685_l((Entity)fence) || player.func_70068_e((Entity)fence) <= 9.0)) {
            AxisAlignedBB selection = fence.func_174813_aQ().func_72317_d(-dx, -dy, -dz).func_186662_g(0.002);
            WorldRenderer.func_228430_a_((MatrixStack)matrix, (IVertexBuilder)buf, (AxisAlignedBB)selection, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
        }
    }

    private void renderHighlight(Connection connection, MatrixStack matrix, IVertexBuilder buf) {
        Catenary cat = connection.getCatenary();
        if (cat == null) {
            return;
        }
        Vector3f p = new Vector3f();
        Vector3f v1 = new Vector3f();
        Vector3f v2 = new Vector3f();
        float r = connection.getRadius() + 0.01f;
        for (int edge = 0; edge < 4; ++edge) {
            int n;
            p.func_195905_a(cat.getX(0), cat.getY(0), cat.getZ(0));
            v1.func_195905_a(cat.getDx(0), cat.getDy(0), cat.getDz(0));
            v1.func_229194_d_();
            v2.func_195905_a(-v1.func_195899_a(), -v1.func_195900_b(), -v1.func_195902_c());
            for (n = 0; edge == 0 && n < 8; ++n) {
                this.addVertex(matrix, buf, (n + 1) / 2 % 4, p, v1, v2, r);
            }
            this.addVertex(matrix, buf, edge, p, v1, v2, r);
            for (int i = 1; i < cat.getCount() - 1; ++i) {
                p.func_195905_a(cat.getX(i), cat.getY(i), cat.getZ(i));
                v2.func_195905_a(-cat.getDx(i), -cat.getDy(i), -cat.getDz(i));
                v2.func_229194_d_();
                this.addVertex(matrix, buf, edge, p, v1, v2, r);
                this.addVertex(matrix, buf, edge, p, v1, v2, r);
                v1.func_195905_a(-v2.func_195899_a(), -v2.func_195900_b(), -v2.func_195902_c());
            }
            p.func_195905_a(cat.getX(), cat.getY(), cat.getZ());
            v2.func_195905_a(-v1.func_195899_a(), -v1.func_195900_b(), -v1.func_195902_c());
            this.addVertex(matrix, buf, edge, p, v1, v2, r);
            for (n = 0; edge == 0 && n < 8; ++n) {
                this.addVertex(matrix, buf, (n + 1) / 2 % 4, p, v1, v2, r);
            }
        }
    }

    private void addVertex(MatrixStack matrix, IVertexBuilder buf, int edge, Vector3f p, Vector3f v1, Vector3f v2, float r) {
        Vector3f up = new Vector3f();
        Vector3f side = new Vector3f();
        if (v1.func_195903_b(v2) < -0.99f) {
            float h = MathHelper.func_76129_c((float)(v1.func_195899_a() * v1.func_195899_a() + v1.func_195902_c() * v1.func_195902_c()));
            if (h < 0.01f) {
                up.func_195905_a(-1.0f, 0.0f, 0.0f);
            } else {
                up.func_195905_a(-v1.func_195899_a() / h * -v1.func_195900_b(), -h, -v1.func_195902_c() / h * -v1.func_195900_b());
            }
        } else {
            up.func_195905_a(v2.func_195899_a(), v2.func_195900_b(), v2.func_195902_c());
            up.func_229190_a_(v1, 0.5f);
        }
        up.func_229194_d_();
        side.func_195905_a(v1.func_195899_a(), v1.func_195900_b(), v1.func_195902_c());
        side.func_195896_c(up);
        side.func_229194_d_();
        side.func_195898_a(edge == 0 || edge == 3 ? -r : r);
        up.func_195898_a(edge < 2 ? -r : r);
        up.func_229189_a_(side);
        up.func_229189_a_(p);
        buf.func_227888_a_(matrix.func_227866_c_().func_227870_a_(), up.func_195899_a(), up.func_195900_b(), up.func_195902_c()).func_227885_a_(0.0f, 0.0f, 0.0f, 0.4f).func_181675_d();
    }

    private static final class HitResult {
        private final Connection connection;
        private final Intersection intersection;

        public HitResult(Connection connection, Intersection intersection) {
            this.connection = connection;
            this.intersection = intersection;
        }
    }

    static class HitConnection
    extends Entity {
        final HitResult result;

        HitConnection(World world, HitResult result) {
            super(EntityType.field_200765_E, world);
            this.func_145769_d(-1);
            this.result = result;
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76346_g() == Minecraft.func_71410_x().field_71439_g) {
                this.processAction(PlayerAction.ATTACK);
                return true;
            }
            return false;
        }

        public boolean func_184230_a(PlayerEntity player, Hand hand) {
            if (player == Minecraft.func_71410_x().field_71439_g) {
                this.processAction(PlayerAction.INTERACT);
                return true;
            }
            return false;
        }

        private void processAction(PlayerAction action) {
            this.result.connection.processClientAction((PlayerEntity)Minecraft.func_71410_x().field_71439_g, action, this.result.intersection);
        }

        public ItemStack getPickedResult(RayTraceResult target) {
            return this.result.connection.getItemStack();
        }

        protected void func_70088_a() {
        }

        protected void func_213281_b(CompoundNBT compound) {
        }

        protected void func_70037_a(CompoundNBT compound) {
        }

        public IPacket<?> func_213297_N() {
            return new IPacket<INetHandler>(){

                public void func_148837_a(PacketBuffer buf) {
                }

                public void func_148840_b(PacketBuffer buf) {
                }

                public void func_148833_a(INetHandler handler) {
                }
            };
        }
    }
}

