/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.client.command;

import com.google.common.collect.ImmutableMap;
import com.google.gson.internal.UnsafeAllocator;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ICommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.DebugProfiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class ClientCommandProvider {
    private static final UnsafeAllocator ALLOCATOR = UnsafeAllocator.create();
    private final Commands commands;
    private final ImmutableMap<String, CommandBuilder> builders;
    private final Pattern chatPredicate;

    public ClientCommandProvider(Commands commands, ImmutableMap<String, CommandBuilder> builders, Pattern chatPredicate) {
        this.commands = commands;
        this.builders = builders;
        this.chatPredicate = chatPredicate;
    }

    private void onKeyPressedEvent(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        if (event.getGui() instanceof ChatScreen) {
            ClientPlayNetHandler net = Minecraft.func_71410_x().func_147114_u();
            if (net == null) {
                return;
            }
            RootCommandNode root = net.func_195515_i().getRoot();
            for (Map.Entry e : this.builders.entrySet()) {
                if (root.getChild((String)e.getKey()) != null) continue;
                root.addChild((CommandNode)((CommandBuilder)e.getValue()).build(new SuggestionHelper()).build());
            }
        }
    }

    private void onChatEvent(ClientChatEvent event) {
        String message = event.getMessage();
        if (this.chatPredicate.matcher(message).matches()) {
            event.setCanceled(true);
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(message);
            ClientPlayerEntity user = Minecraft.func_71410_x().field_71439_g;
            if (user != null) {
                this.commands.func_197059_a(this.createSource((Entity)user), message);
            }
        }
    }

    private CommandSource createSource(Entity entity) {
        return new CommandSource((ICommandSource)new NoLoggingSource(entity), entity.func_213303_ch(), entity.func_189653_aC(), null, 4, entity.func_200200_C_().getString(), entity.func_145748_c_(), (MinecraftServer)DummyServer.INSTANCE, entity);
    }

    public void register(IEventBus bus) {
        bus.addListener(this::onKeyPressedEvent);
        bus.addListener(this::onChatEvent);
    }

    private static <T> T instantiate(Class<T> clazz) {
        try {
            return (T)ALLOCATOR.newInstance(clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class NoLoggingSource
    implements ICommandSource {
        private final Entity entity;

        public NoLoggingSource(Entity entity) {
            this.entity = entity;
        }

        public void func_145747_a(ITextComponent message) {
            this.entity.func_145747_a(message);
        }

        public boolean func_195039_a() {
            return true;
        }

        public boolean func_195040_b() {
            return true;
        }

        public boolean func_195041_r_() {
            return false;
        }
    }

    private static final class DummyServer
    extends IntegratedServer {
        private static final DummyServer INSTANCE = (DummyServer)((Object)ClientCommandProvider.access$200(DummyServer.class));

        public DummyServer() {
            super(null, null, null, null, null, null, null, null, null);
        }

        public DebugProfiler func_213185_aS() {
            return new DebugProfiler(() -> 0);
        }
    }

    private static final class SuggestionHelper
    implements Helper<ISuggestionProvider> {
        private SuggestionHelper() {
        }

        @Override
        public <T extends ArgumentBuilder<ISuggestionProvider, T>> T executes(T builder, Command<CommandSource> command) {
            return builder;
        }
    }

    private static final class ExecutionHelper
    implements Helper<CommandSource> {
        private ExecutionHelper() {
        }

        @Override
        public <T extends ArgumentBuilder<CommandSource, T>> T executes(T builder, Command<CommandSource> command) {
            return (T)builder.executes(command);
        }
    }

    public static interface Helper<S> {
        public <T extends ArgumentBuilder<S, T>> T executes(T var1, Command<CommandSource> var2);
    }

    public static interface CommandBuilder {
        public <S> LiteralArgumentBuilder<S> build(Helper<S> var1);
    }

    public static final class Builder {
        private final List<CommandBuilder> builders = new ArrayList<CommandBuilder>();

        public <S> Builder add(CommandBuilder builder) {
            this.builders.add(builder);
            return this;
        }

        public ClientCommandProvider build() {
            Commands commands = (Commands)ClientCommandProvider.instantiate(Commands.class);
            CommandDispatcher dispatcher = new CommandDispatcher();
            ImmutableMap.Builder map = new ImmutableMap.Builder();
            for (CommandBuilder builder : this.builders) {
                map.put((Object)dispatcher.register(builder.build(new ExecutionHelper())).getName(), (Object)builder);
            }
            ObfuscationReflectionHelper.setPrivateValue(Commands.class, (Object)commands, (Object)dispatcher, (String)"field_197062_b");
            ImmutableMap builders = map.build();
            Pattern pattern = Pattern.compile(String.format("^/(%s)(\\p{javaWhitespace}.*|$)", builders.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"))), 32);
            return new ClientCommandProvider(commands, (ImmutableMap<String, CommandBuilder>)builders, pattern);
        }
    }
}

